/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalAdminSecurityAware;
import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoveBuildError
extends BambooActionSupport
implements GlobalAdminSecurityAware {
    private static final Logger log = Logger.getLogger(RemoveBuildError.class);
    @Autowired
    private ErrorHandler errorHandler;
    @Autowired
    private CachedPlanManager cachedPlanManager;
    private String error;
    private String errorKey;
    private Integer buildNumber;

    public void setError(String error) {
        this.error = error;
    }

    public String execute() throws Exception {
        try {
            int errorNumber = Integer.parseInt(this.error);
            this.errorHandler.removeError(this.errorKey, errorNumber);
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove error from the log", (Throwable)e);
            return "error";
        }
        return "success";
    }

    public String removeAllErrors() throws Exception {
        try {
            this.errorHandler.clear();
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove errors from the logs", (Throwable)e);
            return "error";
        }
        return "success";
    }

    public String removePlanErrors() throws Exception {
        try {
            PlanKey planKey = PlanKeys.getPlanKey((String)this.errorKey);
            ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planKey);
            Preconditions.checkArgument((plan != null ? 1 : 0) != 0, (String)"Could not find Plan with provided key %s", (Object)this.errorKey);
            this.removeErrors(plan.getKey());
            ImmutableChain chain = (ImmutableChain)Narrow.to((Object)plan, ImmutableChain.class);
            if (chain != null) {
                for (ImmutableJob job : chain.getAllJobs()) {
                    this.removeErrors(job.getKey());
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to remove errors from the logs", (Throwable)e);
            return "error";
        }
        return "success";
    }

    private void removeErrors(String planKey) {
        if (this.buildNumber == null) {
            this.errorHandler.removeBuildErrors(planKey);
        } else {
            this.removeErrors(PlanKeys.getPlanResultKey((String)planKey, (int)this.buildNumber));
        }
    }

    private void removeErrors(PlanResultKey planResultKey) {
        for (ErrorDetails error : this.errorHandler.getErrors((ResultKey)planResultKey)) {
            this.errorHandler.removeError(error.getBuildKey(), error.getErrorNumber());
        }
    }

    public void setErrorKey(String errorKey) {
        this.errorKey = errorKey;
    }

    public void setBuildNumber(Integer buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public Object getSecuredDomainObject() {
        return GlobalApplicationSecureObject.INSTANCE;
    }
}

