/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.less;

import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.LookAndFeelConfiguration;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class LookAndFeelLessProvider {
    private static final Pattern CSS_LITERAL = Pattern.compile("^(([A-Za-z-]+)|(#[A-Za-z0-9]+)|(\\d*\\.?\\d+? *(px|%|em|pc|ex|in|deg|s|ms|pt|cm|mm|rad|grad|turn)?)|[\"'])$");
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public LookAndFeelLessProvider(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public String makeLookAndFeelLess() {
        LookAndFeelConfiguration lookandfeelConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration().getLookAndFeelConfiguration();
        ImmutableMap lookandfeelLessVariables = ImmutableMap.builder().put((Object)LookAndFeelConfiguration.LessVariables.PRIMARY_HEADER_COLOR.lessPropertyName, (Object)lookandfeelConfiguration.getPrimaryHeaderColor()).put((Object)LookAndFeelConfiguration.LessVariables.SECONDARY_HEADER_COLOR.lessPropertyName, (Object)lookandfeelConfiguration.getSecondaryHeaderColor()).build();
        StringBuilder out = new StringBuilder();
        for (Map.Entry entry : lookandfeelLessVariables.entrySet()) {
            out.append("@").append((String)entry.getKey()).append(": ");
            out.append(this.encodeValue((String)entry.getValue())).append(";\n");
        }
        return out.toString();
    }

    public String encodeState() {
        return String.valueOf(this.administrationConfigurationAccessor.getAdministrationConfiguration().getWebResourcesSystemCounter());
    }

    private String encodeValue(String value) {
        if (CSS_LITERAL.matcher(value = StringUtils.trimToEmpty((String)value)).matches()) {
            return value;
        }
        value = value.replaceAll("['\"]", "\\$0");
        return '\"' + value + '\"';
    }
}

