/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jsonator.internal;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.jsonator.DefaultIntrospector;
import com.atlassian.bamboo.jsonator.Introspector;
import com.atlassian.bamboo.jsonator.Jsonator;
import com.atlassian.bamboo.web.Jsonate;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Internal
public class ObjectJsonator {
    private static final Logger log = Logger.getLogger(ObjectJsonator.class);
    private final Introspector introspector = DefaultIntrospector.getInstance();
    private final Jsonator.EnumConversionMode enumConversionMode;
    private final InternalJsonator<Object> PRIMITIVE_JSONATOR = new InternalJsonator<Object>(){

        @Override
        public JsonElement convert(Object object) {
            if (object == null) {
                return JsonNull.INSTANCE;
            }
            if (object instanceof String) {
                return new JsonPrimitive((String)object);
            }
            if (object instanceof Number) {
                return new JsonPrimitive((Number)object);
            }
            if (object instanceof Boolean) {
                return new JsonPrimitive((Boolean)object);
            }
            throw new IllegalArgumentException("Passed object is not a primitive: " + object);
        }
    };
    private final InternalJsonator<Collection<?>> COLLECTION_JSONATOR = new InternalJsonator<Collection<?>>(){

        @Override
        public JsonElement convert(Collection<?> collection) {
            return this.convertElements(collection);
        }

        private <T> JsonElement convertElements(Collection<T> collection) {
            JsonArray jsonArray = new JsonArray();
            for (T o : collection) {
                JsonElement json = ObjectJsonator.this.convert(o);
                jsonArray.add(json);
            }
            return jsonArray;
        }
    };
    private final InternalJsonator<Map<?, ?>> MAP_JSONATOR = new InternalJsonator<Map<?, ?>>(){

        @Override
        public JsonElement convert(Map<?, ?> map) {
            return this.convertMap(map);
        }

        private <K, V> JsonElement convertMap(Map<K, V> map) {
            JsonObject result = new JsonObject();
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K key = entry.getKey();
                V value = entry.getValue();
                JsonElement json = ObjectJsonator.this.convert(value);
                result.add(key.toString(), json);
            }
            return result;
        }
    };
    private final InternalJsonator<Object> OBJECT_PROPERTIES_JSONATOR = new InternalJsonator<Object>(){

        @Override
        public JsonElement convert(Object object) {
            Map<String, Object> properties = ObjectJsonator.this.introspector.getProperties(object, Jsonate.class);
            properties.remove("class");
            properties.remove("declaringClass");
            return ObjectJsonator.this.MAP_JSONATOR.convert(properties);
        }
    };
    private final InternalJsonator<Enum> ENUM_JSONATOR = new InternalJsonator<Enum>(){

        @Override
        public JsonElement convert(Enum object) {
            if (ObjectJsonator.this.enumConversionMode == Jsonator.EnumConversionMode.NAME_ONLY) {
                return new JsonPrimitive(object.name());
            }
            return ObjectJsonator.this.OBJECT_PROPERTIES_JSONATOR.convert(object);
        }
    };
    private final InternalJsonator<Object> ARRAY_JSONATOR = new InternalJsonator<Object>(){

        @Override
        public JsonElement convert(Object array) {
            JsonArray jsonArray = new JsonArray();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(array, i);
                JsonElement json = ObjectJsonator.this.convert(value);
                jsonArray.add(json);
            }
            return jsonArray;
        }
    };
    private final Map<Class<?>, InternalJsonator<?>> jsonators = ImmutableMap.builder().put(String.class, this.PRIMITIVE_JSONATOR).put(Boolean.class, this.PRIMITIVE_JSONATOR).put(Number.class, this.PRIMITIVE_JSONATOR).put(Byte.class, this.PRIMITIVE_JSONATOR).put(Enum.class, this.ENUM_JSONATOR).put(Collection.class, this.COLLECTION_JSONATOR).put(Map.class, this.MAP_JSONATOR).build();

    public ObjectJsonator(Jsonator.EnumConversionMode enumConversionMode) {
        this.enumConversionMode = enumConversionMode;
    }

    public JsonElement convert(Object bean) {
        if (bean == null) {
            return JsonNull.INSTANCE;
        }
        InternalJsonator<Object> jsonator = this.getJsonator(bean);
        return jsonator.convert(bean);
    }

    @NotNull
    private <T> InternalJsonator<T> getJsonator(@NotNull T value) {
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            return this.ARRAY_JSONATOR;
        }
        for (Map.Entry<Class<?>, InternalJsonator<?>> entry : this.jsonators.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return this.OBJECT_PROPERTIES_JSONATOR;
    }

    private static interface InternalJsonator<T> {
        public JsonElement convert(T var1);
    }
}

