/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.jsonator;

import com.atlassian.bamboo.jsonator.Introspector;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.web.Jsonate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.aop.framework.Advised;

public class DefaultIntrospector
implements Introspector {
    private static final CacheLoader<Pair<Method, Class<? extends Annotation>>, Optional<Annotation>> GET_ANNOTATION_LOADER = new CacheLoader<Pair<Method, Class<? extends Annotation>>, Optional<Annotation>>(){

        public Optional<Annotation> load(Pair<Method, Class<? extends Annotation>> key) throws Exception {
            return Optional.ofNullable(DefaultIntrospector.getAnnotation((Method)key.first, (Class)key.second));
        }
    };
    private final LoadingCache<Pair<Method, Class<? extends Annotation>>, Optional<Annotation>> methodAnnotationCache = CacheBuilder.newBuilder().build(GET_ANNOTATION_LOADER);
    private static final DefaultIntrospector INSTANCE = new DefaultIntrospector();

    private DefaultIntrospector() {
    }

    public static DefaultIntrospector getInstance() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public Map<String, Object> getProperties(@NotNull Object bean, @Nullable Class<? extends Annotation> annotationFilter) {
        Object unwrappedBean = this.unwrapBean(bean);
        return this.getPropertiesInternal(unwrappedBean, annotationFilter);
    }

    private Map<String, Object> getPropertiesInternal(@NotNull Object unwrappedBean, @Nullable Class<? extends Annotation> annotationFilter) {
        try {
            PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)unwrappedBean);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (PropertyDescriptor descriptor : propertyDescriptors) {
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null || annotationFilter != null && !this.cachingIsAnnotationPresent(readMethod, annotationFilter)) continue;
                properties.put(this.getPropertyName(descriptor, readMethod, annotationFilter), readMethod.invoke(unwrappedBean, new Object[0]));
            }
            return properties;
        }
        catch (Exception e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
    }

    private String getPropertyName(PropertyDescriptor descriptor, Method readMethod, @Nullable Class<? extends Annotation> annotationFilter) {
        Annotation annotation;
        Optional<Annotation> optAnnotation;
        if (annotationFilter != null && (optAnnotation = this.cachingGetAnnotation(readMethod, annotationFilter)).isPresent() && (annotation = optAnnotation.get()) instanceof Jsonate) {
            return (String)StringUtils.defaultIfEmpty((CharSequence)((Jsonate)annotation).name(), (CharSequence)descriptor.getName());
        }
        return descriptor.getName();
    }

    private Optional<Annotation> cachingGetAnnotation(Method readMethod, Class<? extends Annotation> annotationFilter) {
        return (Optional)this.methodAnnotationCache.getUnchecked((Object)Pair.make((Object)readMethod, annotationFilter));
    }

    private boolean cachingIsAnnotationPresent(Method readMethod, Class<? extends Annotation> annotationFilter) {
        return this.cachingGetAnnotation(readMethod, annotationFilter).isPresent();
    }

    private Object unwrapBean(Object bean) {
        if (bean instanceof Advised) {
            Advised advised = (Advised)bean;
            try {
                return advised.getTargetSource().getTarget();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to extract ServiceCommand from AspectJ proxy", e);
            }
        }
        return bean;
    }

    @VisibleForTesting
    static boolean isAnnotationPresent(Method method, Class<Jsonate> annotationClass) {
        return DefaultIntrospector.getAnnotation(method, annotationClass) != null;
    }

    @Nullable
    private static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        T annotationDeclaredOnClassOrSuperclass = method.getAnnotation(annotationClass);
        if (annotationDeclaredOnClassOrSuperclass != null) {
            return annotationDeclaredOnClassOrSuperclass;
        }
        for (Class<?> anInterface : method.getDeclaringClass().getInterfaces()) {
            for (Method interfaceMethod : anInterface.getMethods()) {
                T annotation;
                if (!DefaultIntrospector.methodDeclarationMatches(interfaceMethod, method) || (annotation = interfaceMethod.getAnnotation(annotationClass)) == null) continue;
                return annotation;
            }
        }
        return null;
    }

    private static boolean methodDeclarationMatches(Method method1, Method method2) {
        return Objects.equals(method1.getName(), method2.getName()) && Arrays.equals(method1.getParameterTypes(), method2.getParameterTypes());
    }
}

