/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.js;

import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.js.PlanDecorator;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.webwork.StarterAction;
import com.atlassian.user.User;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.support.TransactionTemplate;

public class ViewPlanUpdates
extends StarterAction {
    private long sinceSystemTime;
    private String lastProject;
    private List<Long> ids;
    @Inject
    private PlanExecutionManager planExecutionManager;
    @Inject
    private TransactionTemplate transactionTemplate;
    @Inject
    private ChainExecutionManager chainExecutionManager;

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        Long currentTime = System.currentTimeMillis();
        HashSet plansForDashboard = new HashSet();
        if (!CollectionUtils.isEmpty(this.ids)) {
            this.ids.stream().map(id -> (ImmutableTopLevelPlan)this.cachedPlanManager.getPlanByIdNotThrowing(id.longValue(), ImmutableTopLevelPlan.class)).filter(Objects::nonNull).filter(plan -> this.cachingPermissionManagerFacade.hasPlanPermission(BambooPermission.READ, plan.getId())).forEach(plansForDashboard::add);
            this.cachingPermissionManagerFacade.primeAclCache(plansForDashboard);
        }
        return (JSONObject)this.transactionTemplate.execute(tx -> {
            try {
                return this.createJsonObject(currentTime, Comparators.getTopLevelPlanNameProviderCaseInsensitiveOrdering().sortedCopy((Iterable)plansForDashboard));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    private JSONObject createJsonObject(Long currentTime, List<ImmutableTopLevelPlan> plansForDashboard) throws JSONException {
        JSONObject jsonObject = super.getJsonObject();
        jsonObject.put("currentTime", (Object)currentTime);
        if (plansForDashboard.isEmpty()) {
            return jsonObject;
        }
        User user = this.getUser();
        Collection favouritedBuilds = user != null ? (Collection)this.planManager.filterFavouritedPlans(plansForDashboard, user).stream().filter(plan -> this.bambooPermissionManager.hasPermission(this.getUser().getName(), (Permission)BambooPermission.READ, plan)).collect(Collectors.toSet()) : new HashSet();
        boolean lastProjectFound = false;
        ArrayList<JSONObject> plans = new ArrayList<JSONObject>();
        for (ImmutableTopLevelPlan plan2 : plansForDashboard) {
            if (lastProjectFound && !plan2.getProject().getKey().equals(this.lastProject)) break;
            if (plan2.getProject().getKey().equals(this.lastProject)) {
                lastProjectFound = true;
            }
            boolean isFavourite = favouritedBuilds.contains(plan2);
            PlanResultKey lastResultKey = plan2.getLastResultKey();
            JSONObject planDecoratorJsonObject = new JSONObject((Object)new PlanDecorator(plan2, currentTime, isFavourite, this.chainExecutionManager, this.planExecutionManager, lastResultKey));
            planDecoratorJsonObject.remove("class");
            plans.add(planDecoratorJsonObject);
        }
        jsonObject.put("plans", plans);
        return jsonObject;
    }

    public long getSinceSystemTime() {
        return this.sinceSystemTime;
    }

    public void setSinceSystemTime(long sinceSystemTime) {
        this.sinceSystemTime = sinceSystemTime;
    }

    @Override
    public void setPlanExecutionManager(PlanExecutionManager planExecutionManager) {
        this.planExecutionManager = planExecutionManager;
    }

    @Override
    public void setLastProject(String lastProject) {
        this.lastProject = lastProject;
    }

    public void setIds(List<Long> ids) {
        this.ids = ids;
    }
}

