/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.js;

import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlanSummaryObject {
    private int totalBuildCount;
    private int failedBuildCount;
    private int successfulBuildCount;
    private final ImmutablePlan plan;
    private final List<BuildResultsSummary> builds;
    private BuildResultsSummary latestBuildResultsSummary;

    public PlanSummaryObject(ImmutablePlan plan) {
        this.plan = plan;
        this.builds = new ArrayList<BuildResultsSummary>();
    }

    public ImmutablePlan getPlan() {
        return this.plan;
    }

    public String getKey() {
        return this.getPlan().getKey();
    }

    public String getName() {
        return this.getPlan().getName();
    }

    public int getTotalBuildCount() {
        return this.totalBuildCount;
    }

    public int getFailedBuildCount() {
        return this.failedBuildCount;
    }

    public int getSuccessfulBuildCount() {
        return this.successfulBuildCount;
    }

    public List<? extends BuildResultsSummary> getBuilds() {
        return this.builds;
    }

    public <T extends BuildResultsSummary> void addBuildResultsSummary(@NotNull T buildResultsSummary) {
        ++this.totalBuildCount;
        if (buildResultsSummary.isSuccessful()) {
            ++this.successfulBuildCount;
        } else if (buildResultsSummary.isFailed()) {
            ++this.failedBuildCount;
        }
        this.builds.add(buildResultsSummary);
        if (this.latestBuildResultsSummary == null) {
            this.latestBuildResultsSummary = buildResultsSummary;
        }
    }
}

