/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.js;

import com.atlassian.bamboo.js.PlanSummaryObject;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.jetbrains.annotations.NotNull;

@NotThreadSafe
public class PlanSummariesObject {
    private final Map<PlanKey, PlanSummaryObject> planSummaries;
    private final CachedPlanManager cachedPlanManager;

    public PlanSummariesObject(@NotNull CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
        this.planSummaries = new TreeMap<PlanKey, PlanSummaryObject>();
    }

    @NotNull
    public Collection<PlanSummaryObject> getPlanSummaries() {
        return this.planSummaries.values();
    }

    public void addBuildResultsSummary(@NotNull BuildResultsSummary buildResultsSummary) {
        PlanKey planKey = buildResultsSummary.getPlanKey();
        this.planSummaries.computeIfAbsent(planKey, p -> new PlanSummaryObject(this.cachedPlanManager.getPlanByKey(p)));
        PlanSummaryObject summaryObject = this.planSummaries.get(planKey);
        summaryObject.addBuildResultsSummary(buildResultsSummary);
    }

    public void addBuildResultsSummaries(@NotNull List<? extends BuildResultsSummary> buildResultsSummaries) {
        for (BuildResultsSummary buildResultsSummary : buildResultsSummaries) {
            this.addBuildResultsSummary(buildResultsSummary);
        }
    }
}

