/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.js;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainExecutionManager;
import com.atlassian.bamboo.chains.ImmutableChainResultsSummary;
import com.atlassian.bamboo.plan.PlanExecutionManager;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.util.Narrow;
import org.jetbrains.annotations.Nullable;

public class PlanDecorator {
    static final String STATUS_ICON_CLASS_DISABLED = "icon-disabled";
    static final String STATUS_ICON_CLASS_PASSED = "icon-successful";
    static final String STATUS_ICON_CLASS_FAILED = "icon-failed";
    static final String STATUS_ICON_CLASS_SPECS_FAILURE = "icon-specs-failure";
    static final String STATUS_ICON_CLASS_SPECS_SUCCESS = "icon-specs-success";
    static final String STATUS_ICON_CLASS_QUEUED = "icon-queued";
    static final String STATUS_ICON_CLASS_BUILDING = "icon-building";
    static final String STATUS_ICON_CLASS_SYNC = "icon-sync";
    static final String STATUS_ICON_CLASS_NOT_BUILT = "icon-notbuilt";
    static final String STATUS_ICON_CLASS_CONTINUABLE = "icon-successfulPartial";
    static final String STATUS_CLASS_SUSPENDED = "Suspended";
    static final String STATUS_CLASS_NO_BUILDS = "NeverExecuted";
    static final String STATUS_CLASS_PASSED = BuildState.SUCCESS.toString();
    static final String STATUS_CLASS_FAILED = BuildState.FAILED.toString();
    static final String STATUS_CLASS_NOT_BUILT = "NotBuilt";
    static final String STATUS_TEXT_DISABLED = "Plan Disabled";
    static final String STATUS_TEXT_QUEUED = "Build queued";
    static final String STATUS_TEXT_IN_PROGRESS = "Build in progress";
    static final String STATUS_TEXT_SYNC = "Updating repository";
    static final String STATUS_TEXT_NO_BUILDS = "No builds found";
    static final String STATUS_TEXT_PASSED = "Last build succeeded";
    static final String STATUS_TEXT_FAILED = "Last build failed";
    static final String STATUS_TEXT_SPECS_FAILURE = "Specs execution failed";
    static final String STATUS_TEXT_SPECS_SUCCESS = "Specs execution was successful";
    static final String STATUS_TEXT_NOT_BUILT = "Last build failed";
    static final String STATUS_TEXT_CONTINUABLE = "Last build stopped at manual stage";
    static final String STATUS_TEXT_UNKNOWN = "Unknown State";
    static final String BREADCRUMB_DIVIDER = "&rsaquo;";
    static final String NULL_BUILD_NUMBER = "Never Built";
    private Long currentSystemTime;
    private final PlanKey planKey;
    private String statusIconClass = "icon-disabled";
    private String statusText = "Unknown State";
    private String statusClass = "NeverExecuted";
    private String reasonSummary;
    private String reasonSummaryTooltip;
    private String durationSummary;
    private String testSummary;
    private String lastBuiltSummary;
    private boolean allowStop;
    private boolean favourite;
    private String latestBuild;
    private String lastResultKey;
    private boolean suspendedFromBuilding;
    private int numberOfCurrentlyBuildingPlans;

    PlanDecorator(ImmutableTopLevelPlan build, Long currentSystemTime, ChainExecutionManager chainExecutionManager, PlanExecutionManager planExecutionManager) {
        ImmutableResultsSummary latestResultsSummary = build.getLatestResultsSummary();
        ImmutableChainResultsSummary chainResultsSummary = (ImmutableChainResultsSummary)Narrow.to((Object)latestResultsSummary, ImmutableChainResultsSummary.class);
        this.planKey = build.getPlanKey();
        this.currentSystemTime = currentSystemTime;
        BuildState buildState = latestResultsSummary != null ? latestResultsSummary.getBuildState() : null;
        LifeCycleState lifeCycleState = latestResultsSummary != null ? latestResultsSummary.getLifeCycleState() : null;
        this.numberOfCurrentlyBuildingPlans = planExecutionManager.numberOfExecutions(this.planKey);
        if (build.isSuspendedFromBuilding()) {
            this.statusIconClass = STATUS_ICON_CLASS_DISABLED;
            this.statusText = STATUS_TEXT_DISABLED;
            this.statusClass = STATUS_CLASS_SUSPENDED;
            this.suspendedFromBuilding = true;
        } else if (chainExecutionManager.isActive(this.planKey)) {
            if (chainExecutionManager.isExecuting(this.planKey)) {
                this.statusIconClass = STATUS_ICON_CLASS_BUILDING;
                this.statusText = STATUS_TEXT_IN_PROGRESS;
            } else {
                this.statusIconClass = STATUS_ICON_CLASS_QUEUED;
                this.statusText = STATUS_TEXT_QUEUED;
            }
            this.allowStop = true;
        } else if (planExecutionManager.isBusy(this.planKey)) {
            this.statusIconClass = STATUS_ICON_CLASS_SYNC;
            this.statusText = STATUS_TEXT_SYNC;
            this.allowStop = true;
        } else if (latestResultsSummary == null) {
            this.statusIconClass = STATUS_ICON_CLASS_DISABLED;
            this.statusText = STATUS_TEXT_NO_BUILDS;
            this.latestBuild = NULL_BUILD_NUMBER;
        } else if (chainResultsSummary != null && chainResultsSummary.isContinuable()) {
            this.statusClass = BuildState.SUCCESS.toString();
            this.statusIconClass = STATUS_ICON_CLASS_CONTINUABLE;
            this.statusText = STATUS_TEXT_CONTINUABLE;
        } else if (LifeCycleState.isFinished((LifeCycleState)lifeCycleState) && buildState == BuildState.SUCCESS) {
            this.statusClass = BuildState.SUCCESS.toString();
            if (ResultSummaryHelper.isBambooSpecSuccess((ImmutableResultsSummary)latestResultsSummary)) {
                this.statusIconClass = STATUS_ICON_CLASS_SPECS_SUCCESS;
                this.statusText = STATUS_TEXT_SPECS_SUCCESS;
            } else {
                this.statusIconClass = STATUS_ICON_CLASS_PASSED;
                this.statusText = STATUS_TEXT_PASSED;
            }
        } else if (LifeCycleState.isFinished((LifeCycleState)lifeCycleState) && buildState == BuildState.FAILED) {
            this.statusClass = BuildState.FAILED.toString();
            if (ResultSummaryHelper.isBambooSpecFailure((ImmutableResultsSummary)latestResultsSummary)) {
                this.statusIconClass = STATUS_ICON_CLASS_SPECS_FAILURE;
                this.statusText = STATUS_TEXT_SPECS_FAILURE;
            } else {
                this.statusIconClass = STATUS_ICON_CLASS_FAILED;
                this.statusText = "Last build failed";
            }
        } else if (LifeCycleState.isNotBuilt((LifeCycleState)lifeCycleState)) {
            this.statusClass = STATUS_CLASS_NOT_BUILT;
            this.statusIconClass = STATUS_ICON_CLASS_NOT_BUILT;
            this.statusText = "Last build failed";
        }
        if (latestResultsSummary != null) {
            this.reasonSummary = latestResultsSummary.getReasonSummary();
            this.latestBuild = PlanDecorator.decorateBuildNumber(latestResultsSummary.getBuildNumber());
            this.durationSummary = latestResultsSummary.getDurationDescription();
            this.lastBuiltSummary = latestResultsSummary.getRelativeBuildDate();
            this.reasonSummaryTooltip = latestResultsSummary.getChangesListSummary();
            this.testSummary = latestResultsSummary.getTestSummary();
            this.statusClass = build.isSuspendedFromBuilding() ? STATUS_CLASS_SUSPENDED : buildState.toString();
        }
    }

    static String decorateBuildNumber(int buildNumber) {
        return "#" + buildNumber;
    }

    public PlanDecorator(ImmutableTopLevelPlan plan, Long currentTime, boolean favourite, ChainExecutionManager chainExecutionManager, PlanExecutionManager planExecutionManager, @Nullable PlanResultKey lastResultKey) {
        this(plan, currentTime, chainExecutionManager, planExecutionManager);
        this.favourite = favourite;
        this.suspendedFromBuilding = plan.isSuspendedFromBuilding();
        this.lastResultKey = lastResultKey != null ? lastResultKey.getKey() : null;
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public Long getCurrentSystemTime() {
        return this.currentSystemTime;
    }

    public String getPlanKey() {
        return this.planKey.toString();
    }

    public String getStatusIconClass() {
        return this.statusIconClass;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getReasonSummary() {
        return this.reasonSummary;
    }

    public String getReasonSummaryTooltip() {
        return this.reasonSummaryTooltip;
    }

    public String getDurationSummary() {
        return this.durationSummary;
    }

    public String getStatusClass() {
        return this.statusClass;
    }

    public String getTestSummary() {
        return this.testSummary;
    }

    public String getLastBuiltSummary() {
        return this.lastBuiltSummary;
    }

    public boolean isAllowStop() {
        return this.allowStop;
    }

    public String getLatestBuild() {
        return this.latestBuild;
    }

    public boolean isSuspendedFromBuilding() {
        return this.suspendedFromBuilding;
    }

    public int getNumberOfCurrentlyBuildingPlans() {
        return this.numberOfCurrentlyBuildingPlans;
    }

    public String getLastResultKey() {
        return this.lastResultKey;
    }
}

