/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.index.IndexerManager;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.core.util.DateUtils;
import java.util.Date;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class ReindexAction
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ReindexAction.class);
    private DateUtils dateUtils = new DateUtils(ResourceBundle.getBundle(BambooActionSupport.class.getName()));
    private IndexerManager indexerManager;

    public String execute() throws Exception {
        this.indexerManager.triggerFullReindex();
        return "success";
    }

    public String getPrettyApproximateIndexTime() {
        return this.dateUtils.formatDurationPretty(this.indexerManager.getEstimatedReindexTime());
    }

    public Date getEstimatedReindexCompletionTime() {
        return this.indexerManager.getEstimatedReindexCompletionTime();
    }

    public Date getCurrentTime() {
        return new Date();
    }

    public void setIndexerManager(IndexerManager indexerManager) {
        this.indexerManager = indexerManager;
    }
}

