/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.spring.EventuallyAutowired;
import com.atlassian.bamboo.spring.EventuallyAutowiredSupport;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class UrlRewriteFilter
implements Filter {
    private static final Logger log = Logger.getLogger(UrlRewriteFilter.class);
    public static final String ORIGINAL_URL_PROP = "originalUrl";
    private static final String LEVEL_SEP = "-";
    private static final String TEST_CLASS_CASE_SEP = ":";
    public static final String FILTER_MAP_PREFIX = "/browse";
    private static final String PROJECT_MATCH = "/([A-Z0-9]{2,})";
    private static final String BUILD_MATCH = "/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)";
    private static final String RESULTS_MATCH = "/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)";
    private static final String MATCH_EVERYTHING = "/(.*)";
    private static final String MATCH_TEST_CASE_KEY = "/([^\\?:]*):([^\\?:]*)";
    public static final String ACTION_LABEL = "/label";
    public static final String ACTION_FAILURES = "/failures";
    public static final String ACTION_HISTORY = "/history";
    public static final String ACTION_COMMIT = "/commit";
    public static final String ACTION_LOG = "/log";
    public static final String ACTION_WEBHOOKS = "/webhooks";
    public static final String ACTION_PLAN_LOG = "/planlog";
    public static final String ACTION_CONFIG = "/config";
    public static final String ACTION_EDIT_CONFIG = "/editConfig";
    public static final String ACTION_STAGES = "/stages";
    public static final String ACTION_BRANCHES = "/branches";
    public static final String ACTION_QUARANTINE = "/quarantine";
    public static final String ACTION_AGGREGATE = "/aggregate";
    public static final String ACTION_DEPLOYMENTS = "/deployments";
    public static final String ACTION_ISSUES = "/issues";
    public static final String ACTION_LATEST = "/latest";
    public static final String ACTION_LATEST_SUCCESSFUL = "/latestSuccessful";
    public static final String ACTION_TEST = "/test";
    public static final String ACTION_TEST_CASE = "/case";
    public static final String ACTION_ARTIFACT = "/artifact";
    public static final String ACTION_COMMENT = "/comment";
    public static final String ACTION_METADATA = "/metadata";
    public static final String ACTION_AUTHOR = "/author";
    public static final String ACTION_USER = "/user";
    private static final Map<Pattern, String> defaultUrlMappings = new HashMap<Pattern, String>();
    private static final Map<Pattern, String> buildableUrlMappings = new HashMap<Pattern, String>();
    private static final Map<Pattern, String> defaultAndBuildableUrlMappings = new HashMap<Pattern, String>();
    private static final Map<Pattern, String> chainUrlMappings = new HashMap<Pattern, String>();
    private static final Map<Pattern, String> branchUrlMappings = new HashMap<Pattern, String>();
    @EventuallyAutowired
    private EventuallyAvailable eventuallyAvailable;

    private static void putRegex(Map<Pattern, String> map, String regex, String replacement) {
        map.put(Pattern.compile(regex), replacement);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        EventuallyAutowiredSupport.processInjectionBasedOnServletContext(this, filterConfig.getServletContext());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String servletPath = httpServletRequest.getServletPath();
        if (!servletPath.startsWith(FILTER_MAP_PREFIX)) {
            throw new ServletException("UrlRewriteFilter only supports servlet paths starting with \"/browse\". URI:" + servletPath);
        }
        String newUrl = this.parseUrl(servletPath);
        if (newUrl != null) {
            this.forwardTo(newUrl, httpServletRequest, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    @Nullable
    public String parseUrl(@NotNull String servletPath) throws ServletException {
        String path = servletPath;
        if (path.indexOf("/") != 0) {
            path = path.replaceAll("^", "/");
        }
        path = path.replaceAll("/$", "");
        Pattern latestSuccessfulPattern = Pattern.compile("/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/latestSuccessful(/.+)?");
        Matcher latestSuccessfulMatcher = latestSuccessfulPattern.matcher(path);
        if (latestSuccessfulMatcher.matches()) {
            String buildKey = latestSuccessfulMatcher.replaceAll("$1-$2");
            return this.parseUrl(this.getLatestSuccessfulUrl(PlanKeys.getPlanKey((String)buildKey), path));
        }
        Pattern latestPattern = Pattern.compile("/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/latest(/.+)?");
        Matcher latestMatcher = latestPattern.matcher(path);
        if (latestMatcher.matches()) {
            String buildKey = latestMatcher.replaceAll("$1-$2");
            String urlToLatestBuild = this.getLatestUrl(PlanKeys.getPlanKey((String)buildKey), path);
            if (urlToLatestBuild == null) {
                return null;
            }
            return this.parseUrl(urlToLatestBuild);
        }
        Map<Pattern, String> mapping = this.getMappingsForPath(path);
        for (Map.Entry<Pattern, String> entry : mapping.entrySet()) {
            Pattern regex = entry.getKey();
            String replacement = entry.getValue();
            Matcher matcher = regex.matcher(path);
            if (!matcher.matches()) continue;
            return matcher.replaceAll(replacement);
        }
        return null;
    }

    @NotNull
    private Map<Pattern, String> getMappingsForPath(String path) {
        PlanKey planKey = this.getPlanKey(path);
        if (planKey == null) {
            return defaultUrlMappings;
        }
        ImmutablePlan plan = this.eventuallyAvailable.getCachedPlanManager().getPlanByKey(planKey);
        if (plan == null) {
            return defaultAndBuildableUrlMappings;
        }
        if (plan instanceof ImmutableBuildable) {
            return buildableUrlMappings;
        }
        if (plan instanceof ImmutableChainBranch) {
            return branchUrlMappings;
        }
        if (plan instanceof ImmutableChain) {
            return chainUrlMappings;
        }
        return defaultUrlMappings;
    }

    @Nullable
    public PlanKey getPlanKey(String path) {
        try {
            String planKey = this.getKey("/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)(/.+)?", "$1-$2", path);
            if (StringUtils.isNotEmpty((CharSequence)planKey)) {
                assert (planKey != null);
                return PlanKeys.getPlanKey((String)planKey);
            }
            String resultKey = this.getKey("/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)(/.+)?", "$1-$2-$3", path);
            if (StringUtils.isNotEmpty((CharSequence)resultKey)) {
                assert (resultKey != null);
                return PlanKeys.getPlanResultKey((String)resultKey).getPlanKey();
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    public String getKey(String patternString, String replacement, String path) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(path);
        if (matcher.matches()) {
            return matcher.replaceAll(replacement);
        }
        return null;
    }

    public void destroy() {
    }

    private void forwardTo(String path, HttpServletRequest request, ServletResponse response) throws IOException, ServletException {
        request.setAttribute(ORIGINAL_URL_PROP, (Object)request.getServletPath());
        RequestDispatcher dispatcher = request.getRequestDispatcher(path);
        if (dispatcher != null) {
            dispatcher.forward((ServletRequest)request, response);
        }
    }

    @Nullable
    private String getLatestUrl(PlanKey planKey, String servletPath) {
        ImmutablePlan plan = this.eventuallyAvailable.getCachedPlanManager().getPlanByKey(planKey);
        if (plan == null) {
            return null;
        }
        ResultsSummary resultsSummary = this.eventuallyAvailable.getResultsSummaryManager().getLastResultsSummary(planKey.toString(), ResultsSummary.class);
        if (resultsSummary != null) {
            return servletPath.replaceAll(planKey + ACTION_LATEST, resultsSummary.getPlanResultKey().toString());
        }
        return servletPath.substring(0, servletPath.indexOf(ACTION_LATEST));
    }

    private String getLatestSuccessfulUrl(PlanKey planKey, String servletPath) throws ServletException {
        ImmutablePlan build = this.eventuallyAvailable.getCachedPlanManager().getPlanByKey(planKey);
        if (build == null) {
            throw new ServletException("Could not find latest build for " + planKey);
        }
        ResultsSummary resultsSummary = this.eventuallyAvailable.getResultsSummaryManager().findLastResultSummaryWithState(planKey, BuildState.SUCCESS, ResultsSummary.class);
        if (resultsSummary != null) {
            return servletPath.replaceAll(planKey + ACTION_LATEST_SUCCESSFUL, resultsSummary.getPlanResultKey().toString());
        }
        return servletPath.substring(0, servletPath.indexOf(ACTION_LATEST));
    }

    public static Map<Pattern, String> getBuildableUrlMappings() {
        return buildableUrlMappings;
    }

    public static Map<Pattern, String> getChainUrlMappings() {
        return chainUrlMappings;
    }

    static {
        UrlRewriteFilter.putRegex(defaultUrlMappings, FILTER_MAP_PREFIX, "start.action");
        UrlRewriteFilter.putRegex(defaultUrlMappings, "/browse/author/(.*)", "/authors/viewAuthor.action?authorName=$1");
        UrlRewriteFilter.putRegex(defaultUrlMappings, "/browse/user/(.*)", "/users/viewUserSummary.action?currentUserName=$1");
        UrlRewriteFilter.putRegex(defaultUrlMappings, "/browse/label", "/build/label/viewLabels.action");
        UrlRewriteFilter.putRegex(defaultUrlMappings, "/browse/label/(.*)", "/build/label/viewBuildsForLabel.action?labelName=$1");
        UrlRewriteFilter.putRegex(defaultUrlMappings, "/browse/([A-Z0-9]{2,})", "/project/viewProject.action?projectKey=$1");
        UrlRewriteFilter.putRegex(defaultUrlMappings, "/browse/([A-Z0-9]{2,})/label", "/build/label/viewLabels.action?projectKey=$1");
        UrlRewriteFilter.putRegex(defaultUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)", "/build/viewBuildSummary!doDefault.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)", "/build/viewBuildSummary!doDefault.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/label", "/build/label/viewLabels.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/failures", "/build/viewFailurePeriods.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/history", "/build/viewBuildHistory.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/planlog", "/build/viewBuildActivityLog.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/config", "/build/admin/edit/editBuildConfiguration.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/editConfig", "/build/admin/edit/editBuildConfiguration.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/test", "/build/viewTestsSummary.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/test\\?(.*)", "/build/viewTestsSummary.action?buildKey=$1-$2&$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/test/case/(.*)", "/build/viewTestCaseHistory.action?buildKey=$1-$2&testCaseId=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)", "/build/result/viewBuildResults.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/commit", "/build/result/viewBuildCommits.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/artifact", "/build/result/viewBuildArtifacts.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/log", "/build/result/viewBuildLog.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/comment", "/build/result/viewBuildResults.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/issues", "/build/viewJiraIssues.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/metadata", "/build/result/viewBuildResultsMetaData.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/test", "/build/result/viewBuildResultsTests.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/test\\?(.*)", "/build/result/viewBuildResultsTests.action?buildKey=$1-$2&buildNumber=$3&$4");
        UrlRewriteFilter.putRegex(buildableUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/test/case/(.*)", "/build/result/viewTestCaseResult.action?buildKey=$1-$2&buildNumber=$3&testCaseId=$4");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)", "/chain/viewChain.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/config", "/chain/admin/config/editChainConfiguration.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/editConfig", "/chain/admin/config/editChainConfiguration.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/stages", "/chain/admin/config/defaultStages.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/failures", "/chain/viewFailurePeriods.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/history", "/chain/listChainResults.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/planlog", "/chain/viewChainActivityLog.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/issues", "/build/viewJiraIssuesForPlan.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/label", "/build/label/viewLabels.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/branches", "/chain/viewChainBranches.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/test", "/chain/viewTestsSummary.action?buildKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/deployments", "/chain/viewRelatedDeployments.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/quarantine", "/chain/quarantine/viewQuarantinedTests.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/aggregate", "/chain/aggregate/viewChainAggregatedPlugins.action?planKey=$1-$2");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)", "/chain/result/viewChainResult.action?planKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/commit", "/chain/result/viewChainCommits.action?planKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/issues", "/build/viewJiraIssues.action?planKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/test", "/chain/result/viewChainResultTestSummary.action?planKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/comment", "/chain/result/viewChainResult.action?planKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/metadata", "/build/result/viewBuildResultsMetaData.action?planKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/artifact", "/chain/result/viewChainArtifacts.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/webhooks", "/chain/result/viewChainWebhookResponses.action?buildKey=$1-$2&buildNumber=$3");
        UrlRewriteFilter.putRegex(chainUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)-([0-9]+)/log", "/chain/result/viewChainLog.action?buildKey=$1-$2&buildNumber=$3");
        branchUrlMappings.putAll(chainUrlMappings);
        UrlRewriteFilter.putRegex(branchUrlMappings, "/browse/([A-Z0-9]{2,})-([A-Z0-9]{2,}(?:-[A-Z][A-Z0-9]{1,})?)/editConfig", "/branch/admin/config/editChainBranchConfiguration.action?planKey=$1-$2");
        defaultAndBuildableUrlMappings.putAll(defaultUrlMappings);
        defaultAndBuildableUrlMappings.putAll(buildableUrlMappings);
    }

    private static class EventuallyAvailable {
        @Autowired
        private CachedPlanManager cachedPlanManager;
        @Autowired
        private ResultsSummaryManager resultsSummaryManager;

        private EventuallyAvailable() {
        }

        @NotNull
        public CachedPlanManager getCachedPlanManager() {
            return this.cachedPlanManager;
        }

        @NotNull
        public ResultsSummaryManager getResultsSummaryManager() {
            return this.resultsSummaryManager;
        }
    }
}

