/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.Bamboo;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SessionExpiryFilter
implements Filter {
    private static final Logger log = Logger.getLogger(SessionExpiryFilter.class);
    public static final String USER_ACTION_HEADER = "Bamboo-User-Action";
    private static final String LAST_ACCESS_TIME_ATTRIBUTE = "Bamboo-Last-Access-Time";
    private static List<Pair<String, String>> BLACKLISTED = new ArrayList<Pair<String, String>>();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)Narrow.downTo((Object)req, HttpServletRequest.class);
        if (request != null) {
            HttpSession session = request.getSession(true);
            boolean shouldInvalidateSession = this.shouldInvalidateSession(request, session);
            if (shouldInvalidateSession) {
                this.logout(req, session);
            } else if (this.shouldUpdateLastAccessTime(request)) {
                session.setAttribute(LAST_ACCESS_TIME_ATTRIBUTE, (Object)new Date());
            }
        }
        chain.doFilter(req, response);
    }

    private void logout(ServletRequest req, HttpSession session) {
        Bamboo bamboo = (Bamboo)Narrow.downTo((Object)req.getServletContext().getAttribute("com.atlassian.bamboo.Bamboo"), Bamboo.class);
        if (bamboo != null) {
            bamboo.getSessionManager().logout(session.getId());
        }
        session.invalidate();
    }

    private boolean shouldUpdateLastAccessTime(@NotNull HttpServletRequest request) {
        boolean result = true;
        String userActionHeader = request.getHeader(USER_ACTION_HEADER);
        if (StringUtils.isEmpty((CharSequence)userActionHeader)) {
            String method;
            String servletPath = request.getServletPath();
            if (this.isBlackListed(servletPath, method = request.getMethod())) {
                result = false;
            }
        } else if ("false".equalsIgnoreCase(userActionHeader)) {
            result = false;
        }
        return result;
    }

    private boolean isBlackListed(String servletPath, String method) {
        for (Pair<String, String> pair : BLACKLISTED) {
            if (!servletPath.startsWith((String)pair.first) || !((String)pair.second).equals(method)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldInvalidateSession(HttpServletRequest request, HttpSession session) {
        Date lastAccessDate;
        Object lastAccessTime = session.getAttribute(LAST_ACCESS_TIME_ATTRIBUTE);
        if (lastAccessTime != null && (lastAccessDate = (Date)Narrow.downTo((Object)lastAccessTime, Date.class)) != null && this.isSessionExpired(session, lastAccessDate)) {
            log.info((Object)("Session is invalidated for user " + request.getUserPrincipal() + " as last access time was " + lastAccessDate));
            return true;
        }
        return false;
    }

    private boolean isSessionExpired(@NotNull HttpSession session, @NotNull Date lastAccessDate) {
        long sessionWillBeExpiredAt = lastAccessDate.getTime() + TimeUnit.SECONDS.toMillis(session.getMaxInactiveInterval());
        return sessionWillBeExpiredAt < new Date().getTime();
    }

    public void destroy() {
    }

    static {
        BLACKLISTED.add((Pair<String, String>)Pair.make((Object)"/rest/", (Object)"GET"));
        BLACKLISTED.add((Pair<String, String>)Pair.make((Object)"/rest/analytics", (Object)"POST"));
        BLACKLISTED.add((Pair<String, String>)Pair.make((Object)"/ajax/", (Object)"GET"));
        BLACKLISTED.add((Pair<String, String>)Pair.make((Object)"/chain/admin/ajax", (Object)"GET"));
    }
}

