/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.apache.log4j.Logger;

public class SessionCreationForAnonymousUserFilter
implements Filter {
    private static final Logger log = Logger.getLogger(SessionCreationForAnonymousUserFilter.class);

    public void doFilter(ServletRequest rq, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)rq;
        if ((SecurityContextHolder.getContext().getAuthentication() == null || SecurityContextHolder.getContext().getAuthentication() instanceof AnonymousAuthenticationToken) && request.getSession(false) == null) {
            log.debug((Object)"Anonymous user detected and no session exists.  Creating one.");
            request.getSession(true);
        }
        chain.doFilter((ServletRequest)request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

