/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooRunnables;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.config.SecurityConfigFactory;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class SeraphLoginFilter
implements Filter {
    public static final String USER_TOKEN_KEY = "USER_TOKEN_KEY";
    public static final String BAMBOO_SECURITY_BYPASS = "bamboo.security.bypass";
    private static final Logger log = Logger.getLogger(SeraphLoginFilter.class);
    private BambooUserManager bambooUserManager;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        BambooUser bambooUser = null;
        if (request.getAttribute(BAMBOO_SECURITY_BYPASS) == null) {
            String userName = null;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (this.isAuthenticatedByToken(httpRequest)) {
                bambooUser = this.bambooUserManager.getBambooUser(this.getAccessToken(httpRequest));
            } else {
                String currentUserName;
                SecurityConfig securityConfig = SecurityConfigFactory.getInstance(null);
                Principal user = securityConfig.getAuthenticator().getUser(httpRequest);
                if (user != null) {
                    userName = user.getName();
                }
                if ((currentUserName = userName) != null) {
                    bambooUser = this.bambooUserManager.loadUserByUsername(currentUserName);
                }
            }
        }
        BambooRunnables.Throwing2<IOException, ServletException> doFilter = new BambooRunnables.Throwing2<IOException, ServletException>(){

            public void run() throws IOException, ServletException {
                chain.doFilter(request, response);
            }
        };
        if (bambooUser != null) {
            ImpersonationHelper.runAs(bambooUser, (BambooRunnables.ThrowingX)doFilter);
        } else {
            doFilter.run();
        }
    }

    private boolean isAuthenticatedByToken(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            return session.getAttribute("authByAccessToken") != null && session.getAttribute("accessToken") != null;
        }
        return false;
    }

    private AccessToken getAccessToken(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            return (AccessToken)Narrow.to((Object)session.getAttribute("accessToken"), AccessToken.class);
        }
        return null;
    }

    public void destroy() {
    }

    public void setBambooUserManager(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }
}

