/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import javax.servlet.ServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequestReferenceCounter {
    private final String requestReferenceCounterName;
    private final ServletRequest request;
    private final Runnable cleanupCode;

    public RequestReferenceCounter(@NotNull ServletRequest request, @NotNull Object referenceCounterClient, @NotNull Runnable cleanupCode) {
        this.request = request;
        this.requestReferenceCounterName = "REF_COUNTER" + referenceCounterClient.getClass().getName();
        this.cleanupCode = cleanupCode;
        this.incrementReferenceCount();
    }

    private void incrementReferenceCount() {
        Integer count = this.getReferenceCount();
        count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
        this.setReferenceCount(count);
    }

    public void decrement() {
        Integer referenceCount = this.getReferenceCount();
        if (referenceCount != null) {
            int newUsageCount = referenceCount - 1;
            this.setReferenceCount(newUsageCount);
            if (newUsageCount == 0) {
                this.cleanupCode.run();
            }
        }
    }

    @Nullable
    private Integer getReferenceCount() {
        return (Integer)this.request.getAttribute(this.requestReferenceCounterName);
    }

    private void setReferenceCount(Integer count) {
        this.request.setAttribute(this.requestReferenceCounterName, (Object)count);
    }
}

