/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.util.RequestCacheThreadLocal;
import com.atlassian.bamboo.utils.HttpUtils;
import com.atlassian.bamboo.utils.scopedcaches.RequestScopedCaches;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestCacheThreadLocalFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean isInCachingScope = false;
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)Narrow.downTo((Object)servletRequest, HttpServletRequest.class);
            HttpServletResponse httpServletResponse = (HttpServletResponse)Narrow.downTo((Object)servletResponse, HttpServletResponse.class);
            if (httpServletRequest != null && httpServletResponse != null) {
                boolean isMutative = HttpUtils.canMethodMutateState((String)httpServletRequest.getMethod());
                try {
                    RequestCacheThreadLocal.setRequestCache((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
                }
                catch (IllegalArgumentException e) {
                    httpServletResponse.sendError(400, e.getMessage());
                    RequestCacheThreadLocal.clearRequestCache();
                    if (isInCachingScope) {
                        RequestScopedCaches.leaveCachingScope();
                    }
                    return;
                }
                if (!isMutative) {
                    isInCachingScope = true;
                    RequestScopedCaches.enterCachingScope();
                }
            }
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            RequestCacheThreadLocal.clearRequestCache();
            if (isInCachingScope) {
                RequestScopedCaches.leaveCachingScope();
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

