/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.atlassian.util.concurrent.Lazy;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerformanceStatistics {
    private static final Logger log = Logger.getLogger(PerformanceStatistics.class);
    private final ServletPathStats performanceStats = new ServletPathStats();
    private static final int BOREDOM_THRESHOLD = 10;
    private static final Pattern REMOVE_TIMESTAMP = Pattern.compile("&_=\\d*");
    private static final Pattern REMOVE_JSESSIONID = Pattern.compile(";jsessionid=[^&]*");
    private static final Pattern REMOVE_SINCE_SYSTEM_TIME = Pattern.compile("&sinceSystemTime=\\d*");

    public synchronized void add(HttpServletRequest httpServletRequest, long requestProcessingTime) {
        if (requestProcessingTime < 10L) {
            return;
        }
        String servletPath = httpServletRequest.getServletPath();
        UrlStats statsForServletPath = this.performanceStats.getNotNull(servletPath);
        String requestUri = httpServletRequest.getRequestURI();
        int servletPathIndex = requestUri.indexOf(servletPath);
        String pathServedByServlet = servletPathIndex != -1 ? requestUri.substring(servletPathIndex + servletPath.length()) : "";
        String queryString = httpServletRequest.getQueryString();
        String requestParams = queryString != null ? pathServedByServlet + "&" + queryString : pathServedByServlet;
        requestParams = REMOVE_TIMESTAMP.matcher(requestParams).replaceFirst("");
        requestParams = REMOVE_JSESSIONID.matcher(requestParams).replaceFirst("");
        requestParams = REMOVE_SINCE_SYSTEM_TIME.matcher(requestParams).replaceFirst("");
        Times times = statsForServletPath.getNotNull(requestParams);
        times.add((int)requestProcessingTime);
    }

    public synchronized void clear() {
        this.performanceStats.getEntries().clear();
    }

    public synchronized ServletPathStats getSnapshot() {
        return this.performanceStats.getSnapshot();
    }

    public static class ServletPathStats
    implements StatProvider {
        private Map<String, UrlStats> servletPathStats = new HashMap<String, UrlStats>();

        public UrlStats getNotNull(String servletPath) {
            UrlStats urlStats = this.servletPathStats.get(servletPath);
            if (urlStats == null) {
                urlStats = new UrlStats();
                this.servletPathStats.put(servletPath, urlStats);
            }
            return urlStats;
        }

        public ServletPathStats getSnapshot() {
            ServletPathStats clone = new ServletPathStats();
            clone.servletPathStats = new HashMap<String, UrlStats>(this.servletPathStats);
            for (Map.Entry<String, UrlStats> entry : this.servletPathStats.entrySet()) {
                entry.setValue(entry.getValue().getSnapshot());
            }
            return clone;
        }

        public Set<Map.Entry<String, UrlStats>> getEntries() {
            return this.servletPathStats.entrySet();
        }

        @Override
        public Stats getStats() {
            long totalTime = 0L;
            long totalCount = 0L;
            for (UrlStats urlStats : this.servletPathStats.values()) {
                Stats stats = urlStats.getStats();
                totalCount += stats.getCount();
                totalTime += stats.getTotalTime();
            }
            return new Stats(totalTime, totalCount);
        }
    }

    public static class UrlStats
    implements StatProvider {
        private Map<String, Times> urlStatsMap = new HashMap<String, Times>();

        public void put(String url, Times times) {
            this.urlStatsMap.put(url, times);
        }

        @NotNull
        public Times getNotNull(String url) {
            Times times = this.urlStatsMap.get(url);
            if (times == null) {
                times = new Times();
                this.urlStatsMap.put(url, times);
            }
            return times;
        }

        public UrlStats getSnapshot() {
            UrlStats clone = new UrlStats();
            clone.urlStatsMap = new HashMap<String, Times>(this.urlStatsMap);
            for (Map.Entry<String, Times> entry : this.urlStatsMap.entrySet()) {
                entry.setValue(new ImmutableTimes(entry.getValue()));
            }
            return clone;
        }

        public Map<String, Times> getUrlStatsMap() {
            return this.urlStatsMap;
        }

        @Override
        public Stats getStats() {
            long totalTime = 0L;
            long count = 0L;
            for (Times times : this.urlStatsMap.values()) {
                Stats stats = times.getStats();
                totalTime += stats.getTotalTime();
                count += stats.getCount();
            }
            return new Stats(totalTime, count);
        }
    }

    private static class ImmutableTimes
    extends Times {
        private final Supplier<Stats> stats = Lazy.supplier((Supplier)new Supplier<Stats>(){

            @Override
            public Stats get() {
                return ImmutableTimes.super.getStats();
            }
        });

        public ImmutableTimes(Times times) {
            super(times);
        }

        @Override
        public Stats getStats() {
            return this.stats.get();
        }
    }

    private static class Times
    implements StatProvider {
        protected final Collection<Integer> times;

        public Times(Times times) {
            this.times = ImmutableList.copyOf(times.getTimes());
        }

        public Times() {
            this.times = new LinkedList<Integer>();
        }

        @Override
        public Stats getStats() {
            long totalTime = 0L;
            long count = 0L;
            for (Integer time : this.times) {
                totalTime += (long)time.intValue();
                ++count;
            }
            Integer percentile97th = null;
            if (count > 1L) {
                --count;
                totalTime -= (long)this.times.iterator().next().intValue();
                List sortedTimes = Ordering.natural().sortedCopy(Iterables.skip(this.times, (int)1));
                int percentile97thIndex = sortedTimes.size() * 97 / 100;
                percentile97th = (Integer)sortedTimes.get(percentile97thIndex);
            }
            return new Stats(totalTime, count).with97percentile(percentile97th);
        }

        public Collection<Integer> getTimes() {
            return this.times;
        }

        public void add(int requestProcessingTime) {
            this.times.add(requestProcessingTime);
        }
    }

    public static class Stats {
        private final long totalTime;
        private final long count;
        private Integer percentile97;

        public Stats(long totalTime, long count) {
            this.totalTime = totalTime;
            this.count = count;
        }

        public long getTotalTime() {
            return this.totalTime;
        }

        public Integer getPercentile97th() {
            return this.percentile97;
        }

        public long getAvgTime() {
            if (this.count == 0L) {
                return -1L;
            }
            return this.totalTime / this.count;
        }

        public long getCount() {
            return this.count;
        }

        public Stats with97percentile(@Nullable Integer integer) {
            this.percentile97 = integer;
            return this;
        }
    }

    public static interface StatProvider {
        public Stats getStats();
    }
}

