/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.filter.Page;
import com.atlassian.bamboo.util.UrlBuilder;
import java.util.List;
import org.apache.log4j.Logger;

public class Pager<T> {
    private static final Logger log = Logger.getLogger(Pager.class);
    public static final int DEFAULT_PAGE_SIZE = 50;
    public static final String PAGE_INDEX = "pageIndex";
    public static final String PAGE_SIZE = "pageSize";
    private int pageIndex = 0;
    private int pageSize = 50;
    private int totalSize;
    private Page<T> page;
    private final UrlBuilder urlBuilder = new UrlBuilder();

    public Pager() {
    }

    public Pager(int pageSize) {
        this();
        this.pageSize = pageSize;
    }

    public void setPageFromList(List<T> results) {
        int maxPageIndex = Math.max((results.size() - 1) / this.getPageSize(), 0);
        if (this.getPageIndex() > maxPageIndex) {
            this.setPageIndex(maxPageIndex);
        }
        int start = Math.max(this.getPageIndex() * this.getPageSize(), 0);
        int startIndex = Math.min(results.size(), start);
        int endIndex = Math.min(results.size(), start + this.getPageSize());
        List<T> filteredResults = results.subList(startIndex, endIndex);
        this.page = new Page<T>(filteredResults, startIndex, endIndex);
        this.totalSize = results.size();
    }

    public void setPageFromFilteredList(List<T> results, int totalSize) {
        int maxPageIndex = Math.max((totalSize - 1) / this.getPageSize(), 0);
        if (this.getPageIndex() > maxPageIndex) {
            this.setPageIndex(maxPageIndex);
        }
        int start = Math.max(this.getPageIndex() * this.getPageSize(), 0);
        int startIndex = Math.min(totalSize, start);
        int endIndex = Math.min(totalSize, start + this.getPageSize());
        this.page = new Page<T>(results, startIndex, endIndex);
        this.totalSize = totalSize;
    }

    public void setUrlString(String url) {
        this.urlBuilder.setUrl(url);
    }

    public String getFirstPageUrl() {
        this.urlBuilder.setParameter(PAGE_INDEX, String.valueOf(0));
        this.urlBuilder.setParameter(PAGE_SIZE, String.valueOf(this.getPageSize()));
        return this.urlBuilder.toString();
    }

    public String getPreviousPageUrl() {
        this.urlBuilder.setParameter(PAGE_INDEX, String.valueOf(this.getPageIndex() - 1));
        this.urlBuilder.setParameter(PAGE_SIZE, String.valueOf(this.getPageSize()));
        return this.urlBuilder.toString();
    }

    public String getNextPageUrl() {
        this.urlBuilder.setParameter(PAGE_INDEX, String.valueOf(this.getPageIndex() + 1));
        this.urlBuilder.setParameter(PAGE_SIZE, String.valueOf(this.getPageSize()));
        return this.urlBuilder.toString();
    }

    public String getLastPageUrl() {
        this.urlBuilder.setParameter(PAGE_INDEX, String.valueOf(this.getLastPageIndex()));
        this.urlBuilder.setParameter(PAGE_SIZE, String.valueOf(this.getPageSize()));
        return this.urlBuilder.toString();
    }

    public int getLastPageIndex() {
        int totalNumberOfPages = this.getTotalNumberOfPages();
        return totalNumberOfPages - 1;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public int getTotalNumberOfPages() {
        int i = (int)Math.ceil((double)this.totalSize / (double)this.getPageSize());
        return Math.max(i, 1);
    }

    public boolean isHasNextPage() {
        return this.getPageIndex() < this.getLastPageIndex();
    }

    public boolean isHasPreviousPage() {
        return this.getPageIndex() > 0;
    }

    public Page<T> getPage() {
        return this.page;
    }

    public void setPage(Page<T> page) {
        this.page = page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize > 0 ? pageSize : 50;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = Math.max(pageIndex, 0);
    }
}

