/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.util.UrlUtils;
import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;

public class NewRelicTransactionNamingFilter
implements Filter {
    private static final Logger log = Logger.getLogger(NewRelicTransactionNamingFilter.class);
    public static final String NEWRELIC_TRANS_NAME_PARAM = "com.newrelic.agent.TRANSACTION_NAME";

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request;
        String requestURI;
        ActionProxy proxy;
        ActionInvocation actionInvocation;
        chain.doFilter(req, resp);
        ActionContext context = ServletActionContext.getContext();
        String possibleName = null;
        if (context != null && (actionInvocation = context.getActionInvocation()) != null && (proxy = actionInvocation.getProxy()) != null) {
            possibleName = UrlUtils.appendSlashIfDoesntExist((String)proxy.getNamespace()) + proxy.getActionName();
        }
        if (possibleName == null && req instanceof HttpServletRequest && (requestURI = (request = (HttpServletRequest)req).getRequestURI()) != null && requestURI.contains("rest/api")) {
            possibleName = requestURI;
        }
        if (possibleName != null) {
            NewRelicTransactionNamingFilter.setTransactionName(req, possibleName);
        }
    }

    public static void setTransactionName(ServletRequest request, String name) {
        request.setAttribute(NEWRELIC_TRANS_NAME_PARAM, (Object)name);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

