/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.seraph.util.PathMapper;
import com.atlassian.spring.container.ContainerManager;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class LicenseFilter
extends AbstractHttpFilter {
    private static final Logger log = Logger.getLogger(LicenseFilter.class);
    private PathMapper ignorePaths;
    static final String UPDATE_LICENSE_DEFAULT_PATH = "/allowLicenseUpdateOrShowExpirationInfo!doDefault.action";
    private BambooLicenseManager bambooLicenseManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String[] ignoredPathsArray = new String[]{"/setup/*", "/func/*", "/bootstrap/*", "/bower/*", "/webwork * ", "/error/*", "/styles/*", "/layout/setup/*", "/images/*", "/scripts/*", "/500.action", "/404.action", "/download", "/api/rest/logToServer.action", "/userlogin!doDefault.action", "/userlogin.action", "/userLogout!doDefault.action", "/userLogout.action", "/captcha*", "/rest/pref/latest/user/*", "/rest/menu/latest/appswitcher*", "/forgotPassword!doDefault.action", "/forgotPassword.action", UPDATE_LICENSE_DEFAULT_PATH, "/admin/updateLicense*"};
        this.ignorePaths = new PathMapper();
        for (String path : ignoredPathsArray) {
            this.ignorePaths.put(path, path);
        }
    }

    public void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String uri = request.getServletPath();
        if (!this.ignoreUri(uri) && !this.getBambooLicenseManager().isLicenseValid()) {
            log.debug((Object)"No valid license found.");
            response.sendRedirect(request.getContextPath() + UPDATE_LICENSE_DEFAULT_PATH);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean ignoreUri(String uri) {
        return this.ignorePaths.get(uri) != null;
    }

    public BambooLicenseManager getBambooLicenseManager() {
        if (this.bambooLicenseManager == null) {
            this.bambooLicenseManager = (BambooLicenseManager)ContainerManager.getComponent((String)"bambooLicenseManager");
        }
        return this.bambooLicenseManager;
    }

    void setBambooLicenseManager(BambooLicenseManager bambooLicenseManager) {
        this.bambooLicenseManager = bambooLicenseManager;
    }
}

