/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

final class HttpCacheControlUtils {
    private static final Logger log = Logger.getLogger(HttpCacheControlUtils.class);
    private static final String NO_STORE = "no-store";
    private static final String PRIVATE = "private";

    private HttpCacheControlUtils() {
    }

    static void setNoStore(HttpServletResponse response) {
        String headerValue = response.getHeader("Cache-Control");
        if (headerValue != null && (headerValue.contains(NO_STORE) || headerValue.contains(PRIVATE))) {
            return;
        }
        if (headerValue != null && !headerValue.equals("max-age=0")) {
            log.warn((Object)("The response contains a cookie, overriding cache control header: " + headerValue));
        }
        response.setHeader("Cache-Control", NO_STORE);
    }
}

