/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.filter.HttpCacheControlUtils;
import com.atlassian.bamboo.util.Narrow;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class CookieCacheControlFilter
implements Filter {
    private static final String SET_COOKIE_HEADER_NAME = "Set-Cookie";
    private static final Logger log = Logger.getLogger(CookieCacheControlFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)Narrow.downTo((Object)response, HttpServletResponse.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Narrow.downTo((Object)request, HttpServletRequest.class);
        if (httpServletRequest == null || httpServletResponse == null) {
            chain.doFilter(request, response);
            return;
        }
        final HttpServletResponseWithCacheControl wrappedResponse = new HttpServletResponseWithCacheControl(httpServletResponse);
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(httpServletRequest){

            public HttpSession getSession(boolean create) {
                HttpSession existingSession = super.getSession(false);
                if (existingSession != null || !create) {
                    return existingSession;
                }
                log.debug((Object)"Creating session...");
                HttpSession newSession = super.getSession(true);
                wrappedResponse.updateCacheControl(CookieCacheControlFilter.SET_COOKIE_HEADER_NAME);
                return newSession;
            }
        };
        chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    private static class HttpServletResponseWithCacheControl
    extends HttpServletResponseWrapper {
        HttpServletResponseWithCacheControl(HttpServletResponse httpServletResponse) {
            super(httpServletResponse);
        }

        public void addCookie(Cookie cookie) {
            super.addCookie(cookie);
            this.updateCacheControl(CookieCacheControlFilter.SET_COOKIE_HEADER_NAME);
        }

        public void addHeader(String name, String value) {
            super.addHeader(name, value);
            this.updateCacheControl(name);
        }

        public void setHeader(String name, String value) {
            super.setHeader(name, value);
            this.updateCacheControl(name);
        }

        void updateCacheControl(String name) {
            if (!name.equals(CookieCacheControlFilter.SET_COOKIE_HEADER_NAME)) {
                return;
            }
            HttpCacheControlUtils.setNoStore((HttpServletResponse)this);
        }
    }
}

