/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.utils.SystemProperty;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ClickjackingAndMimeTypeSniffingPreventionFilter
implements Filter {
    private static final String X_FRAME_OPTIONS_VALUE = "SAMEORIGIN";
    private static final String X_CONTENT_TYPE_OPTIONS_VALUE = "nosniff";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!response.containsHeader("X-Frame-Options")) {
            response.addHeader("X-Frame-Options", X_FRAME_OPTIONS_VALUE);
        }
        if (!SystemProperty.DISABLE_X_CONTENT_TYPE_OPTIONS_NOSNIFF.getTypedValue() && !response.containsHeader("X-Content-Type-Options")) {
            response.addHeader("X-Content-Type-Options", X_CONTENT_TYPE_OPTIONS_VALUE);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

