/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.filter.PerformanceStatistics;
import com.atlassian.bamboo.performance.ActionIdentifier;
import com.atlassian.bamboo.performance.ActionType;
import com.atlassian.bamboo.performance.PerformanceStatsService;
import com.atlassian.bamboo.spring.EventuallyAutowired;
import com.atlassian.bamboo.spring.EventuallyAutowiredSupport;
import com.atlassian.bamboo.util.BambooProfilingUtils;
import com.atlassian.bamboo.utils.DebugUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.config.util.BootstrapUtils;
import freemarker.core.profiler.FreemarkerProfiler;
import java.io.IOException;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class BambooProfilingFilter
implements Filter {
    private static final Logger log = Logger.getLogger(BambooProfilingFilter.class);
    public static final PerformanceStatistics performanceStatistics = new PerformanceStatistics();
    public static volatile boolean isRequestProfilingEnabled = SystemProperty.BAMBOO_REQUEST_PROFILING.getValue(false);
    @EventuallyAutowired
    private EventuallyAvailable eventuallyAvailable;

    public void init(FilterConfig filterConfig) throws ServletException {
        EventuallyAutowiredSupport.processInjectionBasedOnServletContext(this, filterConfig.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean enableSQLLogging;
        long requestProcessingStart = System.currentTimeMillis();
        String servletPath = ((HttpServletRequest)request).getServletPath();
        boolean gatherPerformanceData = BootstrapUtils.getBootstrapManager() != null && BootstrapUtils.getBootstrapManager().isSetupComplete() && this.isInterestingPath(servletPath) && this.eventuallyAvailable.getFeatureManager().isPerformanceDataGatheringEnabled();
        boolean bl = enableSQLLogging = isRequestProfilingEnabled && request.getParameter("debugSQL") != null;
        if (enableSQLLogging) {
            DebugUtils.toggleSQLLogging((Level)Level.DEBUG);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            Map profiledCalls;
            if (enableSQLLogging) {
                DebugUtils.toggleSQLLogging((Level)Level.INFO);
            }
            if (!(profiledCalls = FreemarkerProfiler.stopProfiling()).isEmpty()) {
                log.info((Object)BambooProfilingUtils.getTimes((Map)profiledCalls, (int)2));
            }
            if (isRequestProfilingEnabled || gatherPerformanceData) {
                long requestProcessingTime = System.currentTimeMillis() - requestProcessingStart;
                if (isRequestProfilingEnabled) {
                    HttpServletRequest httpServletRequest = (HttpServletRequest)request;
                    performanceStatistics.add(httpServletRequest, requestProcessingTime);
                }
                if (gatherPerformanceData) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Servlet path: " + servletPath + ", time taken (ms): " + requestProcessingTime));
                    }
                    this.eventuallyAvailable.getPerformanceStatsService().recordExecution(new ActionIdentifier(ActionType.STRUTS, servletPath), requestProcessingTime);
                }
            }
        }
    }

    private boolean isInterestingPath(String servletPath) {
        return !servletPath.startsWith("/download") && !servletPath.startsWith("/rest") && !servletPath.startsWith("/setup") && !servletPath.startsWith("/images") && !servletPath.startsWith("/artifact") && !servletPath.startsWith("/plugins") && !servletPath.endsWith(".gif") && !servletPath.endsWith(".png") && !servletPath.endsWith(".jpg") && !servletPath.endsWith(".css") && !servletPath.endsWith(".ico") && !servletPath.endsWith(".js") && !servletPath.contains("logToServer") && !servletPath.contains("/agentServer/") && !servletPath.endsWith(".svg") && !servletPath.endsWith(".swf") && !servletPath.endsWith(".woff") && !servletPath.endsWith(".ttf");
    }

    public void destroy() {
    }

    public static void setRequestProfilingState(boolean value) {
        if (!value) {
            performanceStatistics.clear();
        }
        isRequestProfilingEnabled = value;
    }

    private static class EventuallyAvailable {
        @Inject
        private FeatureManager featureManager;
        @Inject
        private PerformanceStatsService performanceStatsService;

        private EventuallyAvailable() {
        }

        public FeatureManager getFeatureManager() {
            return this.featureManager;
        }

        public PerformanceStatsService getPerformanceStatsService() {
            return this.performanceStatsService;
        }
    }
}

