/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.config.util.BootstrapUtils;
import com.github.ziplet.filter.compression.CompressingFilter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.log4j.Logger;

public class BambooCompressingFilter
implements Filter {
    private static final Logger log = Logger.getLogger(BambooCompressingFilter.class);
    private Supplier<AdministrationConfigurationAccessor> administrationConfigurationAccessor = ComponentAccessor.ADMINISTRATION_CONFIGURATION_ACCESSOR;
    private Filter compressingFilter = new CompressingFilter();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.compressingFilter.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (BootstrapUtils.getBootstrapManager() != null && BootstrapUtils.getBootstrapManager().isSetupComplete() && this.shouldCompress()) {
            this.compressingFilter.doFilter(servletRequest, servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
        this.compressingFilter.destroy();
    }

    @VisibleForTesting
    boolean shouldCompress() {
        AdministrationConfiguration administrationConfiguration = ((AdministrationConfigurationAccessor)this.administrationConfigurationAccessor.get()).getAdministrationConfiguration();
        if (log.isDebugEnabled()) {
            log.debug((Object)("GZIP compression required = " + administrationConfiguration.isUseGzipCompression()));
        }
        return administrationConfiguration.isUseGzipCompression();
    }

    @VisibleForTesting
    void setWrappedFilter(Filter filter) {
        this.compressingFilter = filter;
    }
}

