/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.filter;

import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.analytics.MauService;
import com.atlassian.bamboo.spring.EventuallyAutowired;
import com.atlassian.bamboo.spring.EventuallyAutowiredSupport;
import com.atlassian.bamboo.util.Narrow;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class AccessLogFilter
implements Filter {
    private static final Logger log = Logger.getLogger(AccessLogFilter.class);
    private static volatile boolean isUsernameLoggingEnabled = true;
    @EventuallyAutowired
    private EventuallyAvailable eventuallyAvailable;

    public void init(FilterConfig filterConfig) throws ServletException {
        log.info((Object)"AccessLogFilter initialized. Format is: <user> <url> <starting memory free (kb)> +- <difference in free mem (kb)> <query time (ms)>");
        EventuallyAutowiredSupport.processInjectionBasedOnServletContext(this, filterConfig.getServletContext());
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        boolean ignoreMau;
        MauService mauService;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String url = request.getRequestURL().toString();
        boolean interestingUrl = this.isInterestingUrl(url);
        long startMem = 0L;
        long t1 = System.currentTimeMillis();
        String startText = "";
        if (log.isInfoEnabled() && interestingUrl) {
            startMem = Runtime.getRuntime().freeMemory() >> 10;
            if (log.isInfoEnabled()) {
                startText = this.getStartText(url, request, startMem);
                log.info((Object)startText);
            }
        }
        chain.doFilter(servletRequest, servletResponse);
        if (log.isDebugEnabled() && interestingUrl) {
            long endMem = Runtime.getRuntime().freeMemory() >> 10;
            long memDiff = endMem - startMem;
            long timeDiff = System.currentTimeMillis() - t1;
            log.debug((Object)this.getEndText(response.getStatus(), startText, memDiff, timeDiff));
        }
        if (interestingUrl && (mauService = this.eventuallyAvailable.getMauService()) != null && !(ignoreMau = BooleanUtils.toBoolean((String)request.getHeader("x-atlassian-mau-ignore"))) && !request.getServletPath().startsWith("/setup/")) {
            mauService.recordWebActivity(request);
        }
    }

    protected String getStartText(String url, HttpServletRequest request, long startMem) {
        String user = null;
        if (isUsernameLoggingEnabled && request.getAttribute("bamboo.security.bypass") == null) {
            user = request.getRemoteUser();
        }
        if (StringUtils.isBlank(user)) {
            user = request.getRemoteAddr();
        }
        Optional<AccessToken> accessToken = this.getAccessToken(request);
        StringBuilder buf = new StringBuilder();
        buf.append(user == null ? "-" : "" + user).append(" ");
        accessToken.ifPresent(at -> {
            buf.append("[access-token:");
            buf.append(at.getName());
            buf.append("] ");
        });
        buf.append(request.getMethod());
        buf.append(" ");
        buf.append(url);
        String queryString = request.getQueryString();
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            if (queryString.contains("password")) {
                String[] params;
                StringBuilder paramBuffer = new StringBuilder();
                for (String param : params = queryString.split("&")) {
                    if (param.startsWith("password") || param.startsWith("os_password")) continue;
                    if (paramBuffer.length() == 0) {
                        paramBuffer.append("?");
                    } else {
                        paramBuffer.append("&");
                    }
                    paramBuffer.append(param);
                }
                buf.append((CharSequence)paramBuffer);
            } else {
                buf.append("?");
                buf.append(queryString);
            }
        }
        buf.append(" ").append(startMem);
        buf.append("kb");
        return buf.toString();
    }

    protected String getEndText(int httpStatusCode, String startText, long memDiff, long timeDiff) {
        StringBuilder buf = new StringBuilder();
        buf.append("END: ").append(httpStatusCode != 0 ? httpStatusCode : 200).append(" ").append(startText);
        if (memDiff > 0L) {
            buf.append("+").append(memDiff).append("kb");
        } else if (memDiff < 0L) {
            buf.append(memDiff).append("kb");
        }
        buf.append(" ").append(timeDiff).append("ms");
        return buf.toString();
    }

    protected boolean isInterestingUrl(String url) {
        if (log.isTraceEnabled()) {
            return true;
        }
        return url != null && !url.endsWith(".gif") && !url.endsWith(".png") && !url.endsWith(".jpg") && !url.endsWith(".css") && !url.endsWith(".ico") && !url.endsWith(".js") && !url.contains("logToServer") && !url.contains("/agentServer/") && !url.contains("/rest/capabilities/navigation") && !url.contains("/rest/nav-links-analytics-data") && !url.contains("/rest/stp/1.0/license/") && !url.contains("/plugins/servlet/capabilities") && !url.contains("/rest/api/latest/server") && !url.contains("/rest/gadget") && !url.contains("/plugins/servlet/maven/") && !url.endsWith(".svg") && !url.endsWith(".swf") && !url.endsWith(".woff") && !url.endsWith(".ttf");
    }

    public void destroy() {
    }

    private Optional<AccessToken> getAccessToken(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            return Optional.ofNullable(Narrow.to((Object)session.getAttribute("accessToken"), AccessToken.class));
        }
        return Optional.empty();
    }

    public static void setUsernameLoggingEnabled(boolean value) {
        isUsernameLoggingEnabled = value;
    }

    private static class EventuallyAvailable {
        @Autowired
        private MauService mauService;

        private EventuallyAvailable() {
        }

        @Nullable
        public MauService getMauService() {
            return this.mauService;
        }
    }
}

