/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.db;

import com.atlassian.bamboo.event.ServerStartingEvent;
import com.atlassian.bamboo.logger.AdminErrorHandler;
import com.atlassian.bamboo.utils.db.DatabaseType;
import com.atlassian.bamboo.utils.db.DbmsBean;
import com.atlassian.bamboo.utils.i18n.DocumentationLinkProvider;
import com.atlassian.event.api.EventListener;
import com.opensymphony.xwork2.TextProvider;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.jdbc.Work;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class ValidateOracleJDBCDriverVersion {
    private AdminErrorHandler adminErrorHandler;
    private DocumentationLinkProvider documentationLinkProvider;
    private DbmsBean dbmsBean;
    private HibernateTemplate hibernateTemplate;
    private TextProvider textProvider;

    @EventListener
    public void onEvent(ServerStartingEvent event) {
        if (this.dbmsBean.getDatabaseType() == DatabaseType.ORACLE) {
            this.hibernateTemplate.execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    session.doWork(new Work(){

                        public void execute(Connection connection) throws SQLException {
                            DatabaseMetaData databaseMetaData = connection.getMetaData();
                            String driverVersion = databaseMetaData.getDriverVersion();
                            int driverMajorVersion = databaseMetaData.getDriverMajorVersion();
                            if (driverMajorVersion < 12) {
                                ValidateOracleJDBCDriverVersion.this.adminErrorHandler.recordError("db.error.jdbcDriverOutdated", ValidateOracleJDBCDriverVersion.this.textProvider.getText("config.database.error.oracleDriverOutdated", Arrays.asList(driverVersion, ValidateOracleJDBCDriverVersion.this.documentationLinkProvider.getUrl("db.oracle"))));
                            }
                        }
                    });
                    return null;
                }
            });
        }
    }

    public void setAdminErrorHandler(AdminErrorHandler adminErrorHandler) {
        this.adminErrorHandler = adminErrorHandler;
    }

    public void setDocumentationLinkProvider(DocumentationLinkProvider documentationLinkProvider) {
        this.documentationLinkProvider = documentationLinkProvider;
    }

    public void setDbmsBean(DbmsBean dbmsBean) {
        this.dbmsBean = dbmsBean;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

