/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.bamboo.plugins.web.conditions.UserExistsCondition;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.ConditionallyAccessible;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ConditionallyAccessible(condition={UserExistsCondition.class})
public class ViewAllRepositories
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ViewAllRepositories.class);
    @Autowired
    private RepositoryDefinitionManager repositoryDefinitionManager;
    @Autowired
    private VcsRepositoryManager vcsRepositoryManager;

    public List<RepositoryDisplay> getAllRepositories() {
        return this.repositoryDefinitionManager.getLinkedRepositories().stream().map(x$0 -> new RepositoryDisplay((VcsRepositoryData)x$0)).collect(Collectors.toList());
    }

    public class RepositoryDisplay {
        private final VcsRepositoryData repositoryData;
        private final String locationIdentifier;

        public RepositoryDisplay(VcsRepositoryData repositoryData) {
            this.repositoryData = repositoryData;
            VcsRepositoryModuleDescriptor moduleDescriptor = ViewAllRepositories.this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryData.getPluginKey());
            this.locationIdentifier = moduleDescriptor != null ? moduleDescriptor.getVcsLocationConfigurator().getLocationIdentifier(repositoryData.getVcsLocation()) : "";
        }

        public VcsRepositoryData getRepositoryData() {
            return this.repositoryData;
        }

        public String getLocationIdentifier() {
            return this.locationIdentifier;
        }
    }
}

