/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinitionImpl;
import com.atlassian.bamboo.vcs.viewer.configurator.VcsRepositoryViewerConfigurator;
import com.atlassian.bamboo.vcs.viewer.legacy.LegacyVcsRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerManager;
import com.atlassian.bamboo.vcs.viewer.module.VcsRepositoryViewerModuleDescriptor;
import com.atlassian.bamboo.web.utils.ActionParamHandlingUtils;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.plugin.elements.ResourceLocation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsViewerUIConfigBean {
    private final VcsRepositoryViewerManager viewerManager;
    private final TemplateRenderer templateRenderer;
    public static final String SELECTED_VIEWER = "selectedWebRepositoryViewer";
    public static final VcsViewerTypeSelector NO_VIEWER = new VcsViewerTypeSelector();
    private static final String FREEMARKER = "freemarker";

    public VcsViewerUIConfigBean(VcsRepositoryViewerManager viewerManager, TemplateRenderer templateRenderer) {
        this.viewerManager = viewerManager;
        this.templateRenderer = templateRenderer;
    }

    public List<VcsViewerTypeSelector> getViewerOptionsForRepositoryType(@NotNull String repositoryPluginKey, TaskRenderMode renderMode) {
        return this.getViewerOptionsForRepositoryType(repositoryPluginKey, null, renderMode);
    }

    @NotNull
    public List<VcsViewerTypeSelector> getViewerOptionsForRepositoryType(@NotNull String repositoryPluginKey, @Nullable VcsRepositoryViewerDefinition existingDefinition, TaskRenderMode renderMode) {
        ArrayList result = Lists.newArrayList((Object[])new VcsViewerTypeSelector[]{NO_VIEWER});
        this.viewerManager.getAvailableViewersForRepositoryType(repositoryPluginKey).map(md -> {
            if (existingDefinition != null && md.getCompleteKey().equals(existingDefinition.getPluginKey())) {
                return new VcsViewerTypeSelector((VcsRepositoryViewerModuleDescriptor)md, this.prepareEditHtml((VcsRepositoryViewerModuleDescriptor)md, existingDefinition, renderMode));
            }
            return new VcsViewerTypeSelector((VcsRepositoryViewerModuleDescriptor)md, this.prepareCreateHtml((VcsRepositoryViewerModuleDescriptor)md, renderMode));
        }).forEach(result::add);
        return result;
    }

    public VcsViewerTypeSelector getViewerViewHtml(@NotNull VcsRepositoryViewerDefinition viewerDefinition) {
        VcsRepositoryViewerModuleDescriptor md = null;
        if (viewerDefinition != null) {
            md = this.viewerManager.getVcsRepositoryViewerModuleDescriptor(viewerDefinition.getPluginKey());
        }
        if (md == null) {
            return NO_VIEWER;
        }
        return new VcsViewerTypeSelector(md, this.prepareViewHtml(md, viewerDefinition));
    }

    @Nullable
    public VcsRepositoryViewerDefinition getViewerDefinitionFromActionContext(@NotNull ActionParametersMap actionParametersMap, @NotNull VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor, @Nullable VcsRepositoryViewerDefinition existingDefinition, boolean createPlan) {
        VcsRepositoryViewerModuleDescriptor moduleDescriptor;
        String selectedViewer = actionParametersMap.getString(SELECTED_VIEWER);
        if (createPlan && StringUtils.isBlank((CharSequence)selectedViewer)) {
            selectedViewer = vcsRepositoryModuleDescriptor.getDefaultVcsViewerKey();
        }
        if (StringUtils.isNotBlank((CharSequence)selectedViewer) && !"none:none".equals(selectedViewer) && (moduleDescriptor = this.viewerManager.getVcsRepositoryViewerModuleDescriptor(selectedViewer)) != null && moduleDescriptor.getConfigurator() != null) {
            Map cfgMap = moduleDescriptor.getConfigurator().generateConfigMap(actionParametersMap, existingDefinition);
            if (moduleDescriptor instanceof LegacyVcsRepositoryViewerModuleDescriptor) {
                return new VcsRepositoryViewerDefinitionImpl(selectedViewer, new HashMap(), (String)cfgMap.get("legacyXml"));
            }
            return new VcsRepositoryViewerDefinitionImpl(selectedViewer, cfgMap, null);
        }
        return null;
    }

    public void validateViewerConfiguration(ActionParametersMap actionParametersMap, ErrorCollection errorCollection) {
        VcsRepositoryViewerModuleDescriptor moduleDescriptor;
        String selectedViewer = actionParametersMap.getString(SELECTED_VIEWER);
        if (StringUtils.isNotBlank((CharSequence)selectedViewer) && !NO_VIEWER.getKey().equals(selectedViewer) && (moduleDescriptor = this.viewerManager.getVcsRepositoryViewerModuleDescriptor(selectedViewer)) != null && moduleDescriptor.getConfigurator() != null) {
            moduleDescriptor.getConfigurator().validate(actionParametersMap, errorCollection);
        }
    }

    @NotNull
    private String renderEditHtml(@NotNull VcsRepositoryViewerModuleDescriptor moduleDescriptor, @NotNull Map<String, Object> contextParams, TaskRenderMode renderMode) {
        if (renderMode == TaskRenderMode.ERROR) {
            ActionParamHandlingUtils.appendContextTo(contextParams);
        }
        OgnlStackUtils.putAll(contextParams);
        String html = "";
        ResourceLocation resourceLocation = moduleDescriptor.getResourceLocation(FREEMARKER, "edit");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            html = this.templateRenderer.render(templatePath, contextParams);
        }
        return html;
    }

    private String prepareCreateHtml(VcsRepositoryViewerModuleDescriptor moduleDescriptor, TaskRenderMode renderMode) {
        VcsRepositoryViewerConfigurator configurator = moduleDescriptor.getConfigurator();
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        configurator.populateContextForCreate(contextParams);
        return this.renderEditHtml(moduleDescriptor, contextParams, renderMode);
    }

    private String prepareEditHtml(VcsRepositoryViewerModuleDescriptor moduleDescriptor, VcsRepositoryViewerDefinition previousDefinition, TaskRenderMode renderMode) {
        VcsRepositoryViewerConfigurator configurator = moduleDescriptor.getConfigurator();
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        configurator.populateContextForEdit(contextParams, previousDefinition);
        return this.renderEditHtml(moduleDescriptor, contextParams, renderMode);
    }

    private String prepareViewHtml(VcsRepositoryViewerModuleDescriptor moduleDescriptor, VcsRepositoryViewerDefinition viewerDefinition) {
        VcsRepositoryViewerConfigurator configurator = moduleDescriptor.getConfigurator();
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        configurator.populateContextForView(contextParams, viewerDefinition);
        return this.renderViewHtml(moduleDescriptor, contextParams);
    }

    private String renderViewHtml(VcsRepositoryViewerModuleDescriptor moduleDescriptor, Map<String, Object> contextParams) {
        OgnlStackUtils.putAll(contextParams);
        String html = "";
        ResourceLocation resourceLocation = moduleDescriptor.getResourceLocation(FREEMARKER, "view");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            html = this.templateRenderer.render(templatePath, contextParams);
        }
        return html;
    }

    public static class VcsViewerTypeSelector {
        private final String key;
        private final String name;
        private final String html;

        private VcsViewerTypeSelector() {
            this.key = "none:none";
            this.name = "None";
            this.html = "";
        }

        private VcsViewerTypeSelector(@NotNull VcsRepositoryViewerModuleDescriptor moduleDescriptor, @NotNull String html) {
            this.key = moduleDescriptor.getCompleteKey();
            this.name = moduleDescriptor.getName();
            this.html = html;
        }

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public String getHtml() {
            return this.html;
        }
    }
}

