/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.repository.StandardChangeDetectionOptionsHelper;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.plugin.descriptor.RepositoryModuleDescriptorImpl;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.repository.nullrepository.NullRepository;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configurator.VcsBambooSpecsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsBranchDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsChangeDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryFreemarkerResourceNames;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.web.utils.ActionParamHandlingUtils;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.struts.TextProvider;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.ActionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Internal
public class VcsUIConfigBean {
    private static final Logger log = Logger.getLogger(VcsUIConfigBean.class);
    private final VcsRepositoryManager vcsRepositoryManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final TemplateRenderer templateRenderer;
    private final TextProvider textProvider;
    private final VcsViewerUIConfigBean vcsViewerUIConfigBean;
    private final VcsConfigurationHelper vcsConfigurationHelper;
    private final VcsBambooSpecsConfigurator vcsBambooSpecsConfigurator;
    private final NullRepository nullRepository;
    public static final String POM_PATH_CFG_KEY = "mavenImportPomPath";

    public VcsUIConfigBean(VcsRepositoryManager vcsRepositoryManager, RepositoryDefinitionManager repositoryDefinitionManager, TemplateRenderer templateRenderer, TextProvider textProvider, VcsViewerUIConfigBean vcsViewerUIConfigBean, VcsConfigurationHelper vcsConfigurationHelper, VcsBambooSpecsConfigurator vcsBambooSpecsConfigurator) {
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.templateRenderer = templateRenderer;
        this.textProvider = textProvider;
        this.nullRepository = new NullRepository((com.opensymphony.xwork2.TextProvider)textProvider);
        this.vcsViewerUIConfigBean = vcsViewerUIConfigBean;
        this.vcsConfigurationHelper = vcsConfigurationHelper;
        this.vcsBambooSpecsConfigurator = vcsBambooSpecsConfigurator;
    }

    @NotNull
    public VcsHtmlFragments prepareCreateHtmlFragments(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull TaskRenderMode renderMode, @Nullable Long projectId) {
        return this.prepareCreateHtmlFragmentsInternal(vcsDescriptor, renderMode, projectId, false);
    }

    @NotNull
    public VcsHtmlFragments prepareMavenImportHtmlFragments(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull TaskRenderMode renderMode, @Nullable Long projectId) {
        return this.prepareCreateHtmlFragmentsInternal(vcsDescriptor, renderMode, projectId, true);
    }

    @NotNull
    private VcsHtmlFragments prepareCreateHtmlFragmentsInternal(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull TaskRenderMode renderMode, @Nullable Long projectId, boolean mavenImportMode) {
        VcsLocationConfigurator vcsConfigurator = vcsDescriptor.getVcsLocationConfigurator();
        if (vcsConfigurator != null) {
            VcsBranchConfigurator branchConfigurator;
            VcsBranchDetectionOptionsConfigurator branchDetectionOptionsConfigurator;
            HashMap<String, Object> contextParams = new HashMap<String, Object>();
            if (projectId != null) {
                contextParams.put("projectId", projectId);
            }
            vcsConfigurator.populateContextForCreate(contextParams);
            VcsChangeDetectionOptionsConfigurator changeDetectionOptionsConfigurator = vcsDescriptor.getVcsChangeDetectionOptionsConfigurator();
            if (changeDetectionOptionsConfigurator != null) {
                changeDetectionOptionsConfigurator.populateContextForCreate(contextParams);
            }
            if ((branchDetectionOptionsConfigurator = vcsDescriptor.getVcsBranchDetectionOptionsConfigurator()) != null) {
                branchDetectionOptionsConfigurator.populateContextForCreate(contextParams);
            }
            if ((branchConfigurator = vcsDescriptor.getVcsBranchConfigurator()) != null) {
                branchConfigurator.populateContextForCreate(contextParams);
            }
            if (!mavenImportMode || !(vcsDescriptor instanceof LegacyRepositoryModuleDescriptor)) {
                return this.renderEditHtmlFragments(vcsDescriptor, null, contextParams, renderMode);
            }
            return this.renderLegacyMavenImportHtml(vcsDescriptor, null, contextParams, renderMode);
        }
        return VcsHtmlFragments.EMPTY;
    }

    @NotNull
    public VcsHtmlFragments prepareEditHtmlFragments(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull PartialVcsRepositoryData unmergedData, @NotNull TaskRenderMode renderMode, @Nullable Long projectId) {
        VcsBranchConfigurator branchConfigurator;
        VcsBranchDetectionOptionsConfigurator branchDetectionOptionsConfigurator;
        VcsRepositoryData vcsDefinition = unmergedData.getCompleteData();
        VcsLocationConfigurator vcsConfigurator = vcsDescriptor.getVcsLocationConfigurator();
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.put("vcsDefinition", unmergedData.getCompleteData());
        contextParams.put("vcsDefinition", unmergedData.getInheritedData());
        if (projectId != null) {
            contextParams.put("projectId", projectId);
        }
        vcsConfigurator.populateContextForEdit(contextParams, vcsDefinition.getVcsLocation());
        VcsChangeDetectionOptionsConfigurator changeDetectionOptionsConfigurator = vcsDescriptor.getVcsChangeDetectionOptionsConfigurator();
        if (changeDetectionOptionsConfigurator != null && vcsDefinition.getVcsChangeDetectionOptions() != null) {
            changeDetectionOptionsConfigurator.populateContextForEdit(contextParams, vcsDefinition.getVcsChangeDetectionOptions());
        }
        if ((branchDetectionOptionsConfigurator = vcsDescriptor.getVcsBranchDetectionOptionsConfigurator()) != null && vcsDefinition.getVcsBranchDetectionOptions() != null) {
            branchDetectionOptionsConfigurator.populateContextForEdit(contextParams, vcsDefinition.getVcsBranchDetectionOptions());
        }
        if ((branchConfigurator = vcsDescriptor.getVcsBranchConfigurator()) != null && vcsDefinition.getBranch() != null) {
            branchConfigurator.populateContextForEdit(contextParams, vcsDefinition.getBranch());
        }
        if (vcsDescriptor.getBambooSpecsHandler() != null) {
            this.vcsBambooSpecsConfigurator.populateContextForEdit(contextParams, vcsDefinition.getBambooSpecsDetectionOptions());
        }
        return this.renderEditHtmlFragments(vcsDescriptor, vcsDefinition, contextParams, renderMode);
    }

    @NotNull
    public VcsHtmlFragments prepareViewHtmlFragments(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull VcsRepositoryData vcsDefinition, @Nullable Long projectId) {
        VcsLocationConfigurator vcsConfigurator = vcsDescriptor.getVcsLocationConfigurator();
        if (vcsConfigurator != null) {
            VcsBranchConfigurator branchConfigurator;
            VcsBranchDetectionOptionsConfigurator branchDetectionOptionsConfigurator;
            HashMap<String, Object> contextParams = new HashMap<String, Object>();
            contextParams.put("vcsDefinition", vcsDefinition);
            contextParams.put("repositoryId", vcsDefinition.getId());
            if (projectId != null) {
                contextParams.put("projectId", projectId);
            }
            vcsConfigurator.populateContextForView(contextParams, vcsDefinition.getVcsLocation());
            VcsChangeDetectionOptionsConfigurator changeDetectionOptionsConfigurator = vcsDescriptor.getVcsChangeDetectionOptionsConfigurator();
            if (changeDetectionOptionsConfigurator != null && vcsDefinition.getVcsChangeDetectionOptions() != null) {
                changeDetectionOptionsConfigurator.populateContextForView(contextParams, vcsDefinition.getVcsChangeDetectionOptions());
            }
            if ((branchDetectionOptionsConfigurator = vcsDescriptor.getVcsBranchDetectionOptionsConfigurator()) != null && vcsDefinition.getVcsBranchDetectionOptions() != null) {
                branchDetectionOptionsConfigurator.populateContextForView(contextParams, vcsDefinition.getVcsBranchDetectionOptions());
            }
            if ((branchConfigurator = vcsDescriptor.getVcsBranchConfigurator()) != null && vcsDefinition.getBranch() != null) {
                branchConfigurator.populateContextForView(contextParams, vcsDefinition.getBranch());
            }
            if (vcsDescriptor.getBambooSpecsHandler() != null) {
                this.vcsBambooSpecsConfigurator.populateContextForView(contextParams, vcsDefinition.getBambooSpecsDetectionOptions());
            }
            return this.renderViewHtmlFragments(vcsDescriptor, vcsDefinition, contextParams);
        }
        return VcsHtmlFragments.EMPTY;
    }

    public void validateVcsConfiguration(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @Nullable PartialVcsRepositoryData previousVcsData, @NotNull ErrorCollection errorCollection, @NotNull Set<VcsConfigurationHelper.Overrides> overrides) {
        ActionParametersMapImpl apm = new ActionParametersMapImpl(ActionContext.getContext(), true);
        this.vcsConfigurationHelper.validateVcsConfiguration((ActionParametersMap)apm, vcsDescriptor, previousVcsData, errorCollection, overrides);
    }

    @NotNull
    public PartialVcsRepositoryData getPartialVcsConfigurationFromActionData(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull String repositoryName, @Nullable String userDescription, @Nullable PartialVcsRepositoryData previousVcsDefinition, @NotNull Set<VcsConfigurationHelper.Overrides> overrides) {
        return this.getPartialVcsConfigurationFromActionData(vcsDescriptor, repositoryName, userDescription, previousVcsDefinition, false, overrides);
    }

    @NotNull
    public PartialVcsRepositoryData overrideBranchDetectionOptionsWithActionData(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull PartialVcsRepositoryData vcsDefinition) {
        ActionParametersMapImpl apm = new ActionParametersMapImpl(ActionContext.getContext(), true);
        PartialVcsRepositoryDataBuilder cfgBuilder = PartialVcsRepositoryDataBuilder.newBuilder().fullCopy(vcsDefinition);
        VcsBranchDetectionOptionsConfigurator branchDetectionOptionsConfigurator = vcsDescriptor.getVcsBranchDetectionOptionsConfigurator();
        if (branchDetectionOptionsConfigurator != null) {
            VcsBranchDetectionOptions previousBDO = vcsDefinition.getVcsBranchDetectionOptions();
            Map cfgMap = branchDetectionOptionsConfigurator.generateConfigMap((ActionParametersMap)apm, previousBDO);
            if (vcsDefinition.getInheritedData() == null || vcsDefinition.getInheritedData().getVcsBranchDetectionOptions() == null || !cfgMap.equals(vcsDefinition.getInheritedData().getVcsBranchDetectionOptions().getConfiguration())) {
                cfgBuilder.branchDetectionConfiguration(cfgMap);
            } else {
                cfgBuilder.branchDetectionConfiguration(null);
            }
        }
        return cfgBuilder.build();
    }

    @NotNull
    public PartialVcsRepositoryData getPartialVcsConfigurationFromActionData(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull String repositoryName, @Nullable String userDescription, @Nullable PartialVcsRepositoryData previousVcsDefinition, boolean createPlan, @NotNull Set<VcsConfigurationHelper.Overrides> overrides) {
        ActionParametersMapImpl apm = new ActionParametersMapImpl(ActionContext.getContext(), true);
        return this.vcsConfigurationHelper.getNewPartialVcsConfigurationFromActionData((ActionParametersMap)apm, vcsDescriptor, repositoryName, userDescription, previousVcsDefinition, createPlan, overrides);
    }

    @NotNull
    private VcsHtmlFragments renderEditHtmlFragments(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, VcsRepositoryData vcsDefinition, @NotNull Map<String, Object> contextParams, TaskRenderMode renderMode) {
        if (renderMode == TaskRenderMode.ERROR) {
            ActionParamHandlingUtils.appendContextTo(contextParams);
        }
        contextParams.put("repositoryId", vcsDefinition != null ? Long.valueOf(vcsDefinition.getId()) : null);
        HashMap<VcsHtmlFragment, Supplier<String>> fragments = new HashMap<VcsHtmlFragment, Supplier<String>>();
        for (VcsHtmlFragment fragment : VcsHtmlFragment.values()) {
            fragments.put(fragment, () -> {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Rendering content for repository " + vcsDescriptor.getCompleteKey() + ", fragment: " + (Object)((Object)fragment)));
                }
                OgnlStackUtils.putAll((Map)contextParams);
                String html = "";
                ResourceLocation resourceLocation = vcsDescriptor.getResourceLocation("freemarker", fragment.getEditResourceName());
                if (resourceLocation != null) {
                    String templatePath = resourceLocation.getLocation();
                    html = this.templateRenderer.render(templatePath, contextParams);
                }
                if (fragment == VcsHtmlFragment.CHANGE_DETECTION) {
                    html = html + StandardChangeDetectionOptionsHelper.renderEditHtml(this.templateRenderer, vcsDescriptor.getVcsChangeDetectionOptionsConfigurator(), vcsDefinition);
                }
                return html;
            });
        }
        return new VcsHtmlFragments(fragments);
    }

    @NotNull
    private VcsHtmlFragments renderLegacyMavenImportHtml(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, VcsRepositoryData vcsDefinition, @NotNull Map<String, Object> contextParams, TaskRenderMode renderMode) {
        if (renderMode == TaskRenderMode.ERROR) {
            ActionParamHandlingUtils.appendContextTo(contextParams);
        }
        HashMap<VcsHtmlFragment, Supplier<String>> fragments = new HashMap<VcsHtmlFragment, Supplier<String>>();
        OgnlStackUtils.putAll(contextParams);
        LegacyRepositoryModuleDescriptor lrmd = (LegacyRepositoryModuleDescriptor)Narrow.downTo((Object)vcsDescriptor, LegacyRepositoryModuleDescriptor.class);
        Preconditions.checkArgument((lrmd != null ? 1 : 0) != 0);
        for (VcsHtmlFragment fragment : VcsHtmlFragment.values()) {
            fragments.put(fragment, () -> "");
        }
        MavenPomAccessorCapableRepository repository = (MavenPomAccessorCapableRepository)Narrow.downTo((Object)lrmd.getLegacyModule(), MavenPomAccessorCapableRepository.class);
        Preconditions.checkState((repository != null ? 1 : 0) != 0);
        fragments.put(VcsHtmlFragment.SERVER, () -> this.templateRenderer.render(((RepositoryModuleDescriptorImpl)lrmd.getLegacyRepositoryModuleDescriptor()).getMavenPomCheckoutAccessEditTemplate(), contextParams));
        return new VcsHtmlFragments(fragments);
    }

    @NotNull
    private VcsHtmlFragments renderViewHtmlFragments(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, VcsRepositoryData vcsDefinition, @NotNull Map<String, Object> contextParams) {
        HashMap<VcsHtmlFragment, Supplier<String>> fragments = new HashMap<VcsHtmlFragment, Supplier<String>>();
        for (VcsHtmlFragment fragment : VcsHtmlFragment.values()) {
            fragments.put(fragment, () -> {
                OgnlStackUtils.putAll((Map)contextParams);
                String html = "";
                ResourceLocation resourceLocation = vcsDescriptor.getResourceLocation("freemarker", fragment.getViewResourceName());
                if (resourceLocation != null) {
                    String templatePath = resourceLocation.getLocation();
                    html = this.templateRenderer.render(templatePath, contextParams);
                }
                if (fragment == VcsHtmlFragment.CHANGE_DETECTION) {
                    html = html + StandardChangeDetectionOptionsHelper.renderViewHtml(this.templateRenderer, vcsDescriptor.getVcsChangeDetectionOptionsConfigurator(), vcsDefinition);
                }
                return html;
            });
        }
        return new VcsHtmlFragments(fragments);
    }

    @NotNull
    public String renderBranchIntegrationHtml(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, VcsRepositoryData vcsDefinition) {
        ResourceLocation resourceLocation;
        VcsLocationConfigurator vcsConfigurator = vcsDescriptor.getVcsLocationConfigurator();
        if (vcsConfigurator != null && (resourceLocation = vcsDescriptor.getResourceLocation("freemarker", "branchIntegrationEdit")) != null) {
            HashMap contextParams = new HashMap();
            vcsConfigurator.populateContextForView(contextParams, vcsDefinition.getVcsLocation());
            OgnlStackUtils.putAll(contextParams);
            return this.templateRenderer.render(resourceLocation.getLocation(), contextParams);
        }
        return "";
    }

    @NotNull
    public List<VcsTypeSelector> getLinkedRepositoriesForCreate() {
        return this.getVcsTypeSelectorsForCreate(this.repositoryDefinitionManager.getLinkedRepositories(), false);
    }

    @NotNull
    public List<VcsTypeSelector> getLinkedRepositoriesForSpecsCreate() {
        return this.getVcsTypeSelectorsForCreate(this.repositoryDefinitionManager.getLinkedRepositoriesForAdministration(), true);
    }

    private List<VcsTypeSelector> getVcsTypeSelectorsForCreate(@NotNull List<VcsRepositoryData> repositories, boolean onlyRssRepositories) {
        List availableGlobalRepositories = Comparators.getNameProviderCaseInsensitiveOrdering().sortedCopy(repositories);
        ArrayList<VcsTypeSelector> repositorySelectors = new ArrayList<VcsTypeSelector>();
        for (VcsRepositoryData repositoryData : availableGlobalRepositories) {
            VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryData.getPluginKey());
            if (vcsRepositoryModuleDescriptor == null || onlyRssRepositories && vcsRepositoryModuleDescriptor.getBambooSpecsHandler() == null) continue;
            repositorySelectors.add(new VcsTypeSelector(repositoryData, vcsRepositoryModuleDescriptor));
        }
        return repositorySelectors;
    }

    public VcsTypeSelector getNullRepositorySelector() {
        return new VcsTypeSelector(this.nullRepository);
    }

    public static class VcsTypeSelector {
        private final String key;
        private final String pluginKey;
        private final String name;
        private final String type;
        private final String description;
        private final String optionDescription;
        private final VcsHtmlFragments htmlFragments;
        private final String group;
        private final String icon;
        private final String tooltipKey;
        private final boolean primary;
        private final int weight;
        private final boolean hasReadPermission;
        private boolean showQuietPeriod;
        private boolean supportsConnectionTesting;
        private VcsChangeDetectionOptions changeDetectionSourceDefinition;

        private VcsTypeSelector(NullRepository nullRepository) {
            this.key = nullRepository.getKey();
            this.pluginKey = nullRepository.getKey();
            this.type = this.name = nullRepository.getName();
            this.icon = null;
            this.primary = false;
            this.tooltipKey = null;
            this.weight = Integer.MAX_VALUE;
            this.hasReadPermission = true;
            this.description = "";
            this.optionDescription = "";
            this.group = "";
            this.htmlFragments = VcsHtmlFragments.EMPTY;
            this.showQuietPeriod = false;
            this.supportsConnectionTesting = false;
        }

        public VcsTypeSelector(@NotNull VcsRepositoryModuleDescriptor descriptor, @NotNull VcsHtmlFragments fragments) {
            this.key = descriptor.getCompleteKey();
            this.pluginKey = descriptor.getCompleteKey();
            this.type = this.name = descriptor.getName();
            this.description = descriptor.getDescription();
            this.optionDescription = descriptor.getOptionDescription();
            this.htmlFragments = fragments;
            this.group = "";
            this.icon = descriptor.getIcon();
            this.tooltipKey = descriptor.getTooltipKey();
            this.primary = descriptor.isPrimary();
            this.weight = descriptor.getWeight();
            this.hasReadPermission = true;
            VcsChangeDetectionOptionsConfigurator changeDetectionOptionsConfigurator = descriptor.getVcsChangeDetectionOptionsConfigurator();
            this.showQuietPeriod = changeDetectionOptionsConfigurator != null && changeDetectionOptionsConfigurator.isQuietPeriodSupported();
            this.supportsConnectionTesting = descriptor.supportsTestingConnection();
        }

        public VcsTypeSelector(@NotNull VcsRepositoryData repositoryData, @NotNull VcsRepositoryModuleDescriptor descriptor) {
            this.key = Long.toString(repositoryData.getId());
            this.pluginKey = repositoryData.getPluginKey();
            this.name = repositoryData.getName();
            this.type = descriptor.getName();
            this.description = repositoryData.getDescription();
            this.optionDescription = descriptor.getOptionDescription();
            this.htmlFragments = VcsHtmlFragments.EMPTY;
            this.group = "";
            this.icon = descriptor.getIcon();
            this.tooltipKey = descriptor.getTooltipKey();
            this.primary = descriptor.isPrimary();
            this.weight = descriptor.getWeight();
            this.hasReadPermission = true;
            this.showQuietPeriod = false;
            this.supportsConnectionTesting = descriptor.supportsTestingConnection();
        }

        public VcsTypeSelector(@NotNull PartialVcsRepositoryData repositoryData, @NotNull VcsRepositoryModuleDescriptor descriptor, @NotNull String group, @NotNull VcsHtmlFragments fragments, boolean hasReadPermission) {
            this(repositoryData.getCompleteData(), descriptor, group, fragments, hasReadPermission);
        }

        public VcsTypeSelector(@NotNull VcsRepositoryData repositoryData, @NotNull VcsRepositoryModuleDescriptor descriptor, @NotNull String group, @NotNull VcsHtmlFragments fragments, boolean hasReadPermission) {
            this.key = Long.toString(repositoryData.getId());
            this.pluginKey = repositoryData.getPluginKey();
            this.name = repositoryData.getName();
            this.type = descriptor.getName();
            this.description = repositoryData.getDescription();
            this.optionDescription = descriptor.getOptionDescription();
            this.htmlFragments = fragments;
            this.group = group;
            this.icon = descriptor.getIcon();
            this.tooltipKey = descriptor.getTooltipKey();
            this.primary = descriptor.isPrimary();
            this.weight = descriptor.getWeight();
            this.hasReadPermission = hasReadPermission;
            VcsChangeDetectionOptionsConfigurator changeDetectionOptionsConfigurator = descriptor.getVcsChangeDetectionOptionsConfigurator();
            this.showQuietPeriod = changeDetectionOptionsConfigurator != null && changeDetectionOptionsConfigurator.isQuietPeriodSupported();
            this.changeDetectionSourceDefinition = repositoryData.getVcsChangeDetectionOptions();
            this.supportsConnectionTesting = descriptor.supportsTestingConnection();
        }

        @NotNull
        public String getKey() {
            return this.key;
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public boolean hasReadPermission() {
            return this.hasReadPermission;
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getType() {
            return this.type;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @NotNull
        public VcsHtmlFragments getHtmlFragments() {
            return this.htmlFragments;
        }

        @Nullable
        public String getOptionDescription() {
            return this.optionDescription;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getTooltipKey() {
            return this.tooltipKey;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public int getWeight() {
            return this.weight;
        }

        public String getGroup() {
            return this.group;
        }

        public boolean isShowQuietPeriod() {
            return this.showQuietPeriod;
        }

        public boolean isSupportsConnectionTesting() {
            return this.supportsConnectionTesting;
        }

        public VcsChangeDetectionOptions getChangeDetectionSourceDefinition() {
            return this.changeDetectionSourceDefinition;
        }
    }

    public static class VcsHtmlFragments {
        private static final VcsHtmlFragments EMPTY = new VcsHtmlFragments(Collections.emptyMap());
        private final Map<VcsHtmlFragment, Supplier<String>> fragments;

        public static VcsHtmlFragments emptyFragments() {
            return EMPTY;
        }

        private VcsHtmlFragments(@NotNull Map<VcsHtmlFragment, Supplier<String>> fragments) {
            this.fragments = fragments;
        }

        private String getHtmlFor(VcsHtmlFragment fragment) {
            Supplier<String> supplier = this.fragments.get((Object)fragment);
            return supplier != null ? supplier.get() : null;
        }

        @Nullable
        public String getLocationHtml() {
            return this.getHtmlFor(VcsHtmlFragment.SERVER);
        }

        @Nullable
        public String getBranchHtml() {
            return this.getHtmlFor(VcsHtmlFragment.BRANCH);
        }

        @Nullable
        public String getAdvancedServerOptionsHtml() {
            return this.getHtmlFor(VcsHtmlFragment.SERVER_ADVANCED);
        }

        @Nullable
        public String getChangeDetectionOptionsHtml() {
            return this.getHtmlFor(VcsHtmlFragment.CHANGE_DETECTION);
        }

        @Nullable
        public String getBranchDetectionOptionsHtml() {
            return this.getHtmlFor(VcsHtmlFragment.BRANCH_DETECTION);
        }
    }

    public static enum VcsHtmlFragment {
        SERVER(VcsRepositoryFreemarkerResourceNames.EDIT_VCS_SERVER, VcsRepositoryFreemarkerResourceNames.VIEW_VCS_SERVER),
        SERVER_ADVANCED(VcsRepositoryFreemarkerResourceNames.EDIT_VCS_SERVER_ADVANCED, VcsRepositoryFreemarkerResourceNames.VIEW_VCS_SERVER_ADVANCED),
        BRANCH(VcsRepositoryFreemarkerResourceNames.EDIT_VCS_BRANCH, VcsRepositoryFreemarkerResourceNames.VIEW_VCS_BRANCH),
        CHANGE_DETECTION(VcsRepositoryFreemarkerResourceNames.EDIT_CHANGE_DETECTION_OPTS, VcsRepositoryFreemarkerResourceNames.VIEW_CHANGE_DETECTION_OPTS),
        BRANCH_DETECTION(VcsRepositoryFreemarkerResourceNames.EDIT_BRANCH_DETECTION_OPTS, VcsRepositoryFreemarkerResourceNames.VIEW_BRANCH_DETECTION_OPTS);

        private final String editResourceName;
        private final String viewResourceName;

        private VcsHtmlFragment(String editResourceName, String viewResourceName) {
            this.editResourceName = editResourceName;
            this.viewResourceName = viewResourceName;
        }

        public String getEditResourceName() {
            return this.editResourceName;
        }

        public String getViewResourceName() {
            return this.viewResourceName;
        }
    }
}

