/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.repository.StandardChangeDetectionOptionsHelper;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryDataBuilder;
import com.atlassian.bamboo.vcs.configuration.VcsBambooSpecsDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configuration.legacy.LegacyRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyBranchConfigurator;
import com.atlassian.bamboo.vcs.configuration.legacy.configurator.LegacyVcsLocationConfigurator;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.configurator.VcsBambooSpecsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsBranchDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsChangeDetectionOptionsConfigurator;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.viewer.configuration.VcsRepositoryViewerDefinition;
import com.atlassian.struts.TextProvider;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsConfigurationHelperImpl
implements VcsConfigurationHelper {
    private static final String GENERIC_REPOSITORY_VIEWER_KEY = "com.atlassian.bamboo.repository.atlassian-bamboo-repository-viewers:genericRepositoryViewer";
    private static final String GENERIC_VIEWER_URL_CFG_KEY = "webRepository.genericRepositoryViewer.webRepositoryUrl";
    private final VcsViewerUIConfigBean vcsViewerUIConfigBean;
    private final TextProvider textProvider;
    private final BambooPermissionManager bambooPermissionManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    private final VcsBambooSpecsConfigurator vcsBambooSpecsConfigurator;

    public VcsConfigurationHelperImpl(VcsViewerUIConfigBean vcsViewerUIConfigBean, TextProvider textProvider, BambooPermissionManager bambooPermissionManager, RepositoryDefinitionManager repositoryDefinitionManager, VcsRepositoryConfigurationService vcsRepositoryConfigurationService, VcsBambooSpecsConfigurator vcsBambooSpecsConfigurator) {
        this.vcsViewerUIConfigBean = vcsViewerUIConfigBean;
        this.textProvider = textProvider;
        this.bambooPermissionManager = bambooPermissionManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.vcsRepositoryConfigurationService = vcsRepositoryConfigurationService;
        this.vcsBambooSpecsConfigurator = vcsBambooSpecsConfigurator;
    }

    public void validateVcsConfiguration(@NotNull ActionParametersMap apm, @NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @Nullable PartialVcsRepositoryData previousVcsData, @NotNull ErrorCollection errorCollection, @NotNull Set<VcsConfigurationHelper.Overrides> overrides) {
        VcsLocationConfigurator vcsConfigurator = vcsDescriptor.getVcsLocationConfigurator();
        if (vcsConfigurator != null) {
            VcsBranchConfigurator branchConfigurator;
            VcsChangeDetectionOptionsConfigurator changeDetectionOptionsConfigurator;
            if (overrides.contains(VcsConfigurationHelper.Overrides.SERVER)) {
                vcsConfigurator.validate(apm, previousVcsData != null ? previousVcsData.getCompleteData().getVcsLocation() : null, errorCollection);
                VcsBranchDetectionOptionsConfigurator branchDetectionOptionsConfigurator = vcsDescriptor.getVcsBranchDetectionOptionsConfigurator();
                if (branchDetectionOptionsConfigurator != null) {
                    branchDetectionOptionsConfigurator.validate(apm, errorCollection);
                }
                this.vcsViewerUIConfigBean.validateViewerConfiguration(apm, errorCollection);
            }
            if (overrides.contains(VcsConfigurationHelper.Overrides.CHANGE_DETECTION) && (changeDetectionOptionsConfigurator = vcsDescriptor.getVcsChangeDetectionOptionsConfigurator()) != null) {
                changeDetectionOptionsConfigurator.validate(apm, errorCollection);
                StandardChangeDetectionOptionsHelper.validate(changeDetectionOptionsConfigurator, apm, errorCollection, this.textProvider);
            }
            if (overrides.contains(VcsConfigurationHelper.Overrides.BRANCH) && (branchConfigurator = vcsDescriptor.getVcsBranchConfigurator()) != null) {
                branchConfigurator.validate(apm, errorCollection);
            }
            if (overrides.contains(VcsConfigurationHelper.Overrides.BRANCH_DETECTION) && (branchConfigurator = vcsDescriptor.getVcsBranchDetectionOptionsConfigurator()) != null) {
                branchConfigurator.validate(apm, errorCollection);
            }
        }
    }

    public void validateVcsConfigurationForConnectionTesting(@NotNull ActionParametersMap apm, @NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @Nullable PartialVcsRepositoryData previousVcsData, @NotNull ErrorCollection errorCollection) {
        VcsLocationConfigurator vcsConfigurator = vcsDescriptor.getVcsLocationConfigurator();
        if (vcsConfigurator != null) {
            vcsConfigurator.validateForConnectionTesting(apm, previousVcsData != null ? previousVcsData.getVcsLocation() : null, errorCollection);
            VcsBranchConfigurator branchConfigurator = vcsDescriptor.getVcsBranchConfigurator();
            if (branchConfigurator != null) {
                branchConfigurator.validate(apm, errorCollection);
            }
        }
    }

    @NotNull
    public PartialVcsRepositoryData reconfigureRepositoryWithMavenData(@NotNull VcsRepositoryModuleDescriptor oldModuleDescriptor, @NotNull PartialVcsRepositoryData oldData, @Nullable VcsRepositoryModuleDescriptor newModuleDescriptor, @NotNull Map<String, String> newServerConfiguration, @Nullable VcsBranch vcsBranch, @Nullable String webRepositoryUrl) {
        VcsRepositoryModuleDescriptor moduleDescriptor;
        PartialVcsRepositoryDataBuilder cfgBuilder = this.getVcsRepositoryDataBuilder(oldModuleDescriptor, oldData);
        VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = moduleDescriptor = newModuleDescriptor != null ? newModuleDescriptor : oldModuleDescriptor;
        if (newModuleDescriptor != null) {
            if (!moduleDescriptor.getCompleteKey().equals(oldModuleDescriptor.getCompleteKey())) {
                cfgBuilder = PartialVcsRepositoryDataBuilder.newBuilder().name(newModuleDescriptor.getName()).description(newModuleDescriptor.getDescription()).pluginKey(newModuleDescriptor.getCompleteKey());
            }
            if (moduleDescriptor instanceof LegacyRepositoryModuleDescriptor) {
                cfgBuilder.legacyXml(newServerConfiguration.get("legacyXml"));
                cfgBuilder.serverConfiguration((Map)ImmutableMap.of());
                LegacyBranchConfigurator legacyBranchConfigurator = (LegacyBranchConfigurator)Narrow.downTo((Object)moduleDescriptor.getVcsBranchConfigurator(), LegacyBranchConfigurator.class);
                if (legacyBranchConfigurator != null) {
                    cfgBuilder.vcsBranch(legacyBranchConfigurator.getVcsBranchFromRepositoryXml(cfgBuilder.getLegacyXml()));
                    cfgBuilder.branchConfiguration(new HashMap());
                }
            } else {
                VcsBranchConfigurator branchConfigurator;
                moduleDescriptor.getVcsLocationConfigurator().addDefaultsForAdvancedOptions(newServerConfiguration);
                cfgBuilder.serverConfiguration(newServerConfiguration);
                if (vcsBranch != null && (branchConfigurator = moduleDescriptor.getVcsBranchConfigurator()) != null) {
                    HashMap branchCfg = new HashMap();
                    branchConfigurator.setVcsBranchInConfig(branchCfg, vcsBranch);
                    cfgBuilder.branchConfiguration(branchCfg);
                    cfgBuilder.vcsBranch(vcsBranch);
                }
            }
        }
        if (!StringUtils.isBlank((CharSequence)webRepositoryUrl)) {
            HashMap<String, String> viewerConfiguration = new HashMap<String, String>();
            viewerConfiguration.put(GENERIC_VIEWER_URL_CFG_KEY, webRepositoryUrl);
            cfgBuilder.viewerPluginKey(GENERIC_REPOSITORY_VIEWER_KEY);
            cfgBuilder.viewerConfiguration(viewerConfiguration);
        }
        return cfgBuilder.build();
    }

    @NotNull
    private PartialVcsRepositoryDataBuilder getVcsRepositoryDataBuilder(@NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull PartialVcsRepositoryData existingData) {
        PartialVcsRepositoryDataBuilder cfgBuilder = PartialVcsRepositoryDataBuilder.newBuilder().name(existingData.getName()).pluginKey(vcsDescriptor.getCompleteKey()).inheritedData(existingData.getInheritedData()).description(existingData.getDescription());
        if (existingData.getVcsLocation() != null) {
            cfgBuilder.serverConfiguration(existingData.getVcsLocation().getConfiguration());
        }
        if (existingData.getVcsChangeDetectionOptions() != null) {
            cfgBuilder.changeDetectionConfiguration(existingData.getVcsChangeDetectionOptions().getConfiguration());
        }
        if (existingData.getBranch() != null) {
            cfgBuilder.branchConfiguration(existingData.getBranch().getConfiguration());
            cfgBuilder.vcsBranch(existingData.getBranch().getVcsBranch());
        }
        if (existingData.getVcsBranchDetectionOptions() != null) {
            cfgBuilder.branchDetectionConfiguration(existingData.getVcsBranchDetectionOptions().getConfiguration());
        }
        if (existingData.getBambooSpecsConfiguration() != null) {
            cfgBuilder.bambooSpecsDetectionConfiguration(existingData.getBambooSpecsConfiguration().getConfiguration());
        }
        if (vcsDescriptor instanceof LegacyRepositoryModuleDescriptor) {
            cfgBuilder.legacyXml(existingData.getVcsLocation().getLegacyConfigurationXml());
            cfgBuilder.serverConfiguration((Map)ImmutableMap.of());
            LegacyBranchConfigurator legacyBranchConfigurator = (LegacyBranchConfigurator)Narrow.downTo((Object)vcsDescriptor.getVcsBranchConfigurator(), LegacyBranchConfigurator.class);
            if (legacyBranchConfigurator != null) {
                cfgBuilder.vcsBranch(legacyBranchConfigurator.getVcsBranchFromRepositoryXml(cfgBuilder.getLegacyXml()));
                cfgBuilder.branchConfiguration(new HashMap());
            }
        }
        if (existingData.getViewerConfiguration() != null) {
            cfgBuilder.viewerPluginKey(existingData.getViewerConfiguration().getPluginKey());
            cfgBuilder.viewerConfiguration(existingData.getViewerConfiguration().getConfiguration());
            cfgBuilder.legacyViewerXml(existingData.getViewerConfiguration().getLegacyConfigurationXml());
        }
        return cfgBuilder;
    }

    @NotNull
    public PartialVcsRepositoryData getNewPartialVcsConfigurationFromActionData(@NotNull ActionParametersMap apm, @NotNull VcsRepositoryModuleDescriptor vcsDescriptor, @NotNull String repositoryName, @Nullable String userDescription, @Nullable PartialVcsRepositoryData previousVcsDefinition, boolean createPlan, @NotNull Set<VcsConfigurationHelper.Overrides> overrides) {
        VcsRepositoryViewerDefinition previousViewerDefinition;
        VcsRepositoryViewerDefinition viewerDefinition;
        VcsBranchDetectionOptionsConfigurator branchDetectionOptionsConfigurator;
        VcsBranchConfigurator branchConfigurator;
        Map cfgMap;
        VcsChangeDetectionOptionsConfigurator changeDetectionOptionsConfigurator;
        PartialVcsRepositoryDataBuilder cfgBuilder = PartialVcsRepositoryDataBuilder.newBuilder().copyWithEmptyConfig(previousVcsDefinition).name(repositoryName).description(userDescription).pluginKey(vcsDescriptor.getCompleteKey());
        if (overrides.contains(VcsConfigurationHelper.Overrides.SERVER)) {
            VcsLocationConfigurator vcsConfigurator = vcsDescriptor.getVcsLocationConfigurator();
            if (vcsConfigurator != null) {
                VcsLocationDefinition previousLocationDef = previousVcsDefinition != null ? previousVcsDefinition.getCompleteData().getVcsLocation() : null;
                Map serverConfig = vcsConfigurator.generateConfigMap(apm, previousLocationDef);
                if (createPlan) {
                    vcsConfigurator.addDefaultsForAdvancedOptions(serverConfig);
                }
                if (vcsConfigurator instanceof LegacyVcsLocationConfigurator) {
                    LegacyBranchConfigurator legacyBranchConfigurator;
                    cfgBuilder.legacyXml((String)serverConfig.get("legacyXml"));
                    cfgBuilder.serverConfiguration((Map)ImmutableMap.of());
                    VcsBranchConfigurator branchConfigurator2 = vcsDescriptor.getVcsBranchConfigurator();
                    if (branchConfigurator2 != null && (legacyBranchConfigurator = (LegacyBranchConfigurator)Narrow.downTo((Object)branchConfigurator2, LegacyBranchConfigurator.class)) != null) {
                        cfgBuilder.vcsBranch(legacyBranchConfigurator.getVcsBranchFromRepositoryXml(cfgBuilder.getLegacyXml()));
                        cfgBuilder.branchConfiguration(new HashMap());
                    }
                } else {
                    cfgBuilder.serverConfiguration(serverConfig);
                }
            } else {
                cfgBuilder.serverConfiguration(new HashMap());
            }
        }
        if (overrides.contains(VcsConfigurationHelper.Overrides.CHANGE_DETECTION) && (changeDetectionOptionsConfigurator = vcsDescriptor.getVcsChangeDetectionOptionsConfigurator()) != null) {
            VcsChangeDetectionOptions previousCDO = previousVcsDefinition != null ? previousVcsDefinition.getCompleteData().getVcsChangeDetectionOptions() : null;
            cfgMap = changeDetectionOptionsConfigurator.generateConfigMap(apm, previousCDO);
            cfgBuilder.changeDetectionConfiguration(cfgMap);
            StandardChangeDetectionOptionsHelper.addToConfiguration(changeDetectionOptionsConfigurator, cfgMap, apm);
        }
        if (overrides.contains(VcsConfigurationHelper.Overrides.BRANCH) && (branchConfigurator = vcsDescriptor.getVcsBranchConfigurator()) != null && !(branchConfigurator instanceof LegacyBranchConfigurator)) {
            Map serverConfig = overrides.contains(VcsConfigurationHelper.Overrides.SERVER) ? cfgBuilder.getServerConfiguration() : previousVcsDefinition.getCompleteData().getVcsLocation().getConfiguration();
            VcsBranchDefinition previousBD = previousVcsDefinition != null ? previousVcsDefinition.getCompleteData().getBranch() : null;
            Map cfgMap2 = branchConfigurator.generateConfigMap(apm, previousBD, serverConfig);
            cfgBuilder.branchConfiguration(cfgMap2);
            cfgBuilder.vcsBranch(branchConfigurator.getVcsBranchFromConfig(cfgMap2));
        }
        if (overrides.contains(VcsConfigurationHelper.Overrides.BRANCH_DETECTION) && (branchDetectionOptionsConfigurator = vcsDescriptor.getVcsBranchDetectionOptionsConfigurator()) != null) {
            VcsBranchDetectionOptions previousBDO = previousVcsDefinition != null ? previousVcsDefinition.getCompleteData().getVcsBranchDetectionOptions() : null;
            cfgMap = branchDetectionOptionsConfigurator.generateConfigMap(apm, previousBDO);
            cfgBuilder.branchDetectionConfiguration(cfgMap);
        }
        if (overrides.contains(VcsConfigurationHelper.Overrides.SERVER) && (viewerDefinition = this.vcsViewerUIConfigBean.getViewerDefinitionFromActionContext(apm, vcsDescriptor, previousViewerDefinition = previousVcsDefinition != null ? previousVcsDefinition.getCompleteData().getViewerConfiguration() : null, createPlan)) != null) {
            cfgBuilder.viewerPluginKey(viewerDefinition.getPluginKey());
            cfgBuilder.viewerConfiguration(viewerDefinition.getConfiguration());
            cfgBuilder.legacyViewerXml(viewerDefinition.getLegacyConfigurationXml());
        }
        if (vcsDescriptor.getBambooSpecsHandler() != null) {
            VcsBambooSpecsDetectionOptions previousSpecsDetectionOptions = previousVcsDefinition != null ? previousVcsDefinition.getBambooSpecsConfiguration() : null;
            Map bambooSpecsCfgMap = this.vcsBambooSpecsConfigurator.generateConfigMap(apm, previousSpecsDetectionOptions);
            cfgBuilder.bambooSpecsDetectionConfiguration(bambooSpecsCfgMap);
        }
        return cfgBuilder.build();
    }

    @NotNull
    public PartialVcsRepositoryData temporaryVcsDataFromActionParams(@NotNull ActionParametersMap apm, @NotNull VcsRepositoryModuleDescriptor moduleDescriptor, @Nullable PartialVcsRepositoryData existingData, @NotNull Set<VcsConfigurationHelper.Overrides> overrides) {
        return this.getNewPartialVcsConfigurationFromActionData(apm, moduleDescriptor, moduleDescriptor.getName(), "", existingData, existingData == null, overrides);
    }

    public void validateSharedRepositoryName(String repositoryName, ValidationAware validationAware) {
        ErrorCollection errors = this.validateSharedRepositoryName(repositoryName);
        if (errors.hasAnyErrors()) {
            for (Map.Entry fieldError : errors.getFieldErrors().entrySet()) {
                for (String errorText : (List)fieldError.getValue()) {
                    validationAware.addFieldError((String)fieldError.getKey(), errorText);
                }
            }
        }
    }

    @NotNull
    public ErrorCollection validateSharedRepositoryName(String repositoryName) {
        SimpleErrorCollection result = new SimpleErrorCollection();
        result.addErrorCollection(BambooFieldValidate.checkFieldXssSafety((com.opensymphony.xwork2.TextProvider)this.textProvider, (String)"repositoryName", (String)repositoryName));
        if (StringUtils.isBlank((CharSequence)repositoryName)) {
            result.addError("repositoryName", this.textProvider.getText("repository.name.not.set"));
        } else if (repositoryName.length() > 255) {
            result.addError("repositoryName", this.textProvider.getText("repository.shared.name.too.long", (List)ImmutableList.of((Object)255)));
        } else if (this.currentUserHasPermissionToCreateSharedRepository() && this.vcsRepositoryConfigurationService.validateLinkedRepositoryName(repositoryName, null)) {
            result.addError("repositoryName", this.textProvider.getText("repository.shared.name.already.exists"));
        }
        return result;
    }

    public boolean currentUserHasPermissionToCreateSharedRepository() {
        return this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.CREATE_REPOSITORY);
    }

    @Nullable
    public RepositoryDataEntity validateRepositoryExistenceAndPermissions(long repositoryId, ValidationAware validationAware) {
        RepositoryDataEntity repositoryData = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
        if (repositoryData == null) {
            validationAware.addActionError(this.textProvider.getText("repository.shared.idNotExists", Collections.singletonList(String.valueOf(repositoryId))));
        } else if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)repositoryData, null)) {
            validationAware.addActionError(this.textProvider.getText("repository.shared.noPermission", Collections.singletonList(repositoryData.getName())));
        }
        return repositoryData;
    }
}

