/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.configuration.VcsChangeDetectionOptions;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configurator.VcsChangeDetectionOptionsConfigurator;
import com.atlassian.struts.TextProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StandardChangeDetectionOptionsHelper {
    private static final String VIEW_FTL_PATH = "/fragments/repository/viewStandardChangeDetectionOptions.ftl";
    private static final String EDIT_FTL_PATH = "/fragments/repository/editStandardChangeDetectionOptions.ftl";

    private StandardChangeDetectionOptionsHelper() {
    }

    public static void addToConfiguration(@Nullable VcsChangeDetectionOptionsConfigurator configurator, @NotNull Map<String, String> cfgMap, @NotNull ActionParametersMap actionParametersMap) {
        if (configurator != null) {
            if (configurator.isQuietPeriodSupported()) {
                boolean quietPeriodEnabled = actionParametersMap.getBoolean("repository.common.quietPeriod.enabled");
                cfgMap.put("repository.common.quietPeriod.enabled", Boolean.toString(quietPeriodEnabled));
                if (quietPeriodEnabled) {
                    cfgMap.put("repository.common.quietPeriod.period", actionParametersMap.getString("repository.common.quietPeriod.period"));
                    cfgMap.put("repository.common.quietPeriod.maxRetries", actionParametersMap.getString("repository.common.quietPeriod.maxRetries"));
                }
            }
            if (configurator.isCommitIsolationSupported()) {
                cfgMap.put("commit.isolation.option", Boolean.toString(actionParametersMap.getBoolean("commit.isolation.option")));
            }
        }
        cfgMap.put("changeset.filter.pattern.regex", actionParametersMap.getString("changeset.filter.pattern.regex", ""));
        cfgMap.put("filter.pattern.option", actionParametersMap.getString("filter.pattern.option", "none"));
        cfgMap.put("filter.pattern.regex", actionParametersMap.getString("filter.pattern.regex", ""));
    }

    private static void populateContextForAllOperations(@Nullable VcsChangeDetectionOptionsConfigurator configurator, @NotNull Map<String, Object> context) {
        if (configurator != null) {
            context.put("temp_showQuietPeriod", configurator.isQuietPeriodSupported());
            context.put("temp_showCommitIsolation", configurator.isCommitIsolationSupported());
        }
    }

    private static void populateCreateContext(@Nullable VcsChangeDetectionOptionsConfigurator configurator, @NotNull Map<String, Object> context) {
        StandardChangeDetectionOptionsHelper.populateContextForAllOperations(configurator, context);
        if (configurator != null && configurator.isQuietPeriodSupported()) {
            context.put("repository.common.quietPeriod.period", 10);
            context.put("repository.common.quietPeriod.maxRetries", 5);
        }
    }

    private static void populateActionContext(@Nullable VcsChangeDetectionOptionsConfigurator configurator, @NotNull Map<String, Object> context, @NotNull VcsChangeDetectionOptions vcsChangeDetectionOptions) {
        StandardChangeDetectionOptionsHelper.populateContextForAllOperations(configurator, context);
        context.put("changeset.filter.pattern.regex", StringUtils.defaultString((String)vcsChangeDetectionOptions.getChangesetFilterPatternRegex(), (String)""));
        context.put("filter.pattern.option", StringUtils.defaultString((String)vcsChangeDetectionOptions.getFilterFilePatternOption(), (String)"none"));
        context.put("filter.pattern.regex", StringUtils.defaultString((String)vcsChangeDetectionOptions.getFilterFilePatternRegex(), (String)""));
        if (configurator != null) {
            if (configurator.isQuietPeriodSupported()) {
                context.put("repository.common.quietPeriod.enabled", vcsChangeDetectionOptions.isQuietPeriodEnabled());
                context.put("repository.common.quietPeriod.period", vcsChangeDetectionOptions.getQuietPeriod());
                context.put("repository.common.quietPeriod.maxRetries", vcsChangeDetectionOptions.getMaxRetries());
            }
            if (configurator.isCommitIsolationSupported()) {
                context.put("commit.isolation.option", vcsChangeDetectionOptions.isCommitIsolationEnabled());
            }
        }
    }

    public static void validate(@Nullable VcsChangeDetectionOptionsConfigurator configurator, @NotNull ActionParametersMap apm, @NotNull ErrorCollection errorCollection, TextProvider textProvider) {
        String filterPatternOption;
        String changesetFilterRegex = apm.getString("changeset.filter.pattern.regex");
        if (StringUtils.isNotBlank((CharSequence)changesetFilterRegex)) {
            try {
                Pattern.compile(changesetFilterRegex);
            }
            catch (PatternSyntaxException e) {
                errorCollection.addError("changeset.filter.pattern.regex", textProvider.getText("filter.pattern.regex.invalid.error") + " (" + e.getMessage() + ")");
            }
        }
        if ("includeOnly".equals(filterPatternOption = apm.getString("filter.pattern.option")) || "excludeAll".equals(filterPatternOption)) {
            String patternRegex = apm.getString("filter.pattern.regex");
            if (StringUtils.isNotEmpty((CharSequence)patternRegex)) {
                try {
                    Pattern.compile(patternRegex);
                }
                catch (PatternSyntaxException e) {
                    errorCollection.addError("filter.pattern.regex", textProvider.getText("filter.pattern.regex.invalid.error") + " (" + e.getMessage() + ")");
                }
            } else {
                errorCollection.addError("filter.pattern.regex", textProvider.getText("filter.pattern.regex.required.error"));
            }
        }
        if (configurator != null && configurator.isQuietPeriodSupported() && apm.getBoolean("repository.common.quietPeriod.enabled")) {
            StandardChangeDetectionOptionsHelper.validatePositiveInteger("repository.common.quietPeriod.period", "Please specify the quiet period (in seconds)", "Please specify the quiet period as an integer (in seconds)", apm, errorCollection);
            StandardChangeDetectionOptionsHelper.validatePositiveInteger("repository.common.quietPeriod.maxRetries", "Please specify the maximum number of retries", "Please specify the maximum number of retries as an integer", apm, errorCollection);
        }
    }

    private static void validatePositiveInteger(String paramKey, String positiveIntegerText, String notIntegerText, ActionParametersMap apm, ErrorCollection errorCollection) {
        if (!StringUtils.isNumeric((CharSequence)apm.getString(paramKey))) {
            errorCollection.addError(paramKey, notIntegerText);
        }
        String stringValue = apm.getString(paramKey);
        try {
            int value = Integer.parseInt(stringValue);
            if (value < 0) {
                errorCollection.addError(paramKey, positiveIntegerText);
            }
        }
        catch (NumberFormatException e) {
            errorCollection.addError(paramKey, notIntegerText);
        }
    }

    public static String renderEditHtml(TemplateRenderer templateRenderer, @Nullable VcsChangeDetectionOptionsConfigurator configurator, @Nullable VcsRepositoryData vcsDefinition) {
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        if (vcsDefinition != null && vcsDefinition.getVcsChangeDetectionOptions() != null) {
            StandardChangeDetectionOptionsHelper.populateActionContext(configurator, contextParams, vcsDefinition.getVcsChangeDetectionOptions());
        } else {
            StandardChangeDetectionOptionsHelper.populateCreateContext(configurator, contextParams);
        }
        OgnlStackUtils.putAll(contextParams);
        return templateRenderer.render(EDIT_FTL_PATH, contextParams);
    }

    public static String renderViewHtml(TemplateRenderer templateRenderer, @Nullable VcsChangeDetectionOptionsConfigurator configurator, @NotNull VcsRepositoryData vcsDefinition) {
        if (vcsDefinition.getVcsChangeDetectionOptions() == null) {
            return "";
        }
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        StandardChangeDetectionOptionsHelper.populateActionContext(configurator, contextParams, vcsDefinition.getVcsChangeDetectionOptions());
        StringBuilder html = new StringBuilder();
        OgnlStackUtils.putAll(contextParams);
        return templateRenderer.render(VIEW_FTL_PATH, contextParams);
    }
}

