/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.configuration.repository.AbstractLinkedRepositoryAdminAction;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.project.ProjectIdentifier;
import com.atlassian.bamboo.project.ProjectIdentifierImpl;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryPermissionsService;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.util.BambooSpecVersion;
import com.atlassian.bamboo.utils.BambooCollectors;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.mail.MailFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditLinkedRepository
extends AbstractLinkedRepositoryAdminAction {
    private static final Map<BambooPermission, String> PERMISSION_LABELS = ImmutableMap.of((Object)BambooPermission.READ, (Object)"repository.shared.permissions.type.view.heading", (Object)BambooPermission.ADMINISTRATION, (Object)"repository.shared.permissions.type.admin.heading");
    @Inject
    private FeatureManager featureManager;
    @Inject
    private RepositoryPermissionsService repositoryPermissionsService;
    private VcsUIConfigBean.VcsTypeSelector currentVcsTypeSelector;
    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> currentViewersSelectors;
    private String successMessage;
    private boolean permissionsSaved;
    private boolean created;
    private boolean saved;

    @Override
    public void prepare() throws Exception {
        super.prepare();
        if (this.repositoryId != null && this.repositoryId > 0L) {
            if (this.vcsRepositoryData == null) {
                this.addActionError(this.getText("repository.shared.idNotExists", Collections.singletonList(String.valueOf(this.repositoryId))));
            } else if (this.vcsRepositoryModuleDescriptor == null) {
                this.addActionError(this.getText("repository.shared.missingPlugin", Collections.singletonList(this.vcsRepositoryData.getPluginKey())));
            }
        }
        this.prepareVcsAndViewersHtmls(TaskRenderMode.SUCCESS);
    }

    public String input() throws Exception {
        if (this.created) {
            this.successMessage = this.getText("repository.create.success");
        } else if (this.saved) {
            this.successMessage = this.getText("repository.edit.success");
        }
        if (this.permissionsSaved) {
            this.successMessage = this.getText("repository.permissions.saved");
        }
        return "input";
    }

    public String execute() {
        try {
            this.vcsRepositoryData = this.vcsRepositoryConfigurationService.editLinkedRepository(this.repositoryId.longValue(), this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(this.vcsRepositoryModuleDescriptor, this.repositoryName, StringUtils.defaultString((String)this.userDescription, (String)""), this.vcsRepositoryData, VcsConfigurationHelper.OVERRIDE_ALL));
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
        return "success";
    }

    public void validate() {
        this.validateRepositoryConfiguration();
        if (this.hasErrors()) {
            this.prepareVcsAndViewersHtmls(TaskRenderMode.ERROR);
        }
    }

    protected void prepareVcsAndViewersHtmls(TaskRenderMode renderMode) {
        if (this.vcsRepositoryModuleDescriptor != null) {
            this.currentVcsTypeSelector = this.prepareHtml(renderMode);
            this.currentViewersSelectors = this.prepareViewersHtml(renderMode);
        } else {
            this.currentVcsTypeSelector = this.vcsUIConfigBean.getNullRepositorySelector();
            this.currentViewersSelectors = Collections.singletonList(VcsViewerUIConfigBean.NO_VIEWER);
        }
    }

    private VcsUIConfigBean.VcsTypeSelector prepareHtml(@NotNull TaskRenderMode renderMode) {
        return (VcsUIConfigBean.VcsTypeSelector)this.customVariableContext.withVariableSubstitutor(this.customVariableContext.getVariableSubstitutorFactory().newSubstitutorForGlobalContext(), () -> new VcsUIConfigBean.VcsTypeSelector(this.vcsRepositoryModuleDescriptor, this.vcsUIConfigBean.prepareEditHtmlFragments(this.vcsRepositoryModuleDescriptor, this.vcsRepositoryData, renderMode, null)));
    }

    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> prepareViewersHtml(@NotNull TaskRenderMode renderMode) {
        return this.vcsViewerUIConfigBean.getViewerOptionsForRepositoryType(this.currentVcsTypeSelector.getKey(), this.vcsRepositoryData.getViewerConfiguration(), renderMode);
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setPermissionsSaved(boolean saved) {
        this.permissionsSaved = saved;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    public void setSaved(boolean saved) {
        this.saved = saved;
    }

    public List<VcsViewerUIConfigBean.VcsViewerTypeSelector> getViewerSelectors() {
        return this.currentViewersSelectors;
    }

    public VcsUIConfigBean.VcsTypeSelector getCurrentVcsTypeSelector() {
        return this.currentVcsTypeSelector;
    }

    public String getSubmitAction() {
        return "updateLinkedRepository";
    }

    public boolean isBambooSpecsCapable() {
        return this.featureManager.isRepositoryStoredSpecsEnabled() && this.vcsRepositoryModuleDescriptor != null && this.vcsRepositoryModuleDescriptor.getBambooSpecsHandler() != null;
    }

    public boolean isBambooSpecsDetectionEnabled() {
        return this.vcsRepositoryData != null && this.vcsRepositoryData.getBambooSpecsConfiguration() != null && this.vcsRepositoryData.getBambooSpecsConfiguration().isBambooSpecsDetectionEnabled();
    }

    public boolean isBambooSpecsDetectionRequiresWebhooks() {
        if (this.vcsRepositoryData != null) {
            VcsRepositoryModuleDescriptor vcsModuleDesc = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.vcsRepositoryData.getPluginKey());
            return vcsModuleDesc != null && vcsModuleDesc.getBambooSpecsHandler() != null && vcsModuleDesc.getBambooSpecsHandler().isWebhookRequired();
        }
        return false;
    }

    public boolean isBambooSpecsPermittedToAllProjects() {
        try {
            return this.vcsRepositoryData != null && this.rssPermissionManager.isAllProjectsAccess(this.vcsRepositoryData.getId());
        }
        catch (com.atlassian.bamboo.exception.AccessDeniedException e) {
            return false;
        }
    }

    public boolean isBambooSpecsPermittedToAllRepositories() {
        try {
            return this.vcsRepositoryData != null && this.rssPermissionManager.isAllRepositoriesAccess(this.vcsRepositoryData.getId());
        }
        catch (com.atlassian.bamboo.exception.AccessDeniedException e) {
            return false;
        }
    }

    public boolean isBambooSpecsPermittedToAllProjectsEditable() {
        return this.hasAdminPermission() || this.featureManager.isSoxComplianceModeConfigurable() && this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.SOX_COMPLIANCE);
    }

    public boolean isBambooSpecsPermittedToAllRepositoriesEditable() {
        return this.hasAdminPermission() || this.featureManager.isSoxComplianceModeConfigurable() && this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.SOX_COMPLIANCE);
    }

    public boolean isMailServerConfigured() {
        return MailFactory.getServerManager().isDefaultSMTPMailServerDefined();
    }

    public boolean isMailServerEditable() {
        return this.hasAdminPermission();
    }

    public boolean isShowOnboardingDialog() {
        PropertySet properties = this.bambooUserManager.getPropertySet(this.getUser());
        return properties == null || !Boolean.toString(false).equals(properties.getString("bamboo.user.repository.specs.splashscreen.show"));
    }

    public List<ProjectIdentifier> getBambooSpecsPermittedProjects() {
        return this.rssPermissionManager.getAccessibleProjects(this.vcsRepositoryData.getId()).stream().map(projectId -> this.projectManager.getProjectById(projectId.longValue())).filter(Objects::nonNull).map(project -> new ProjectIdentifierImpl(project.getId(), project.getKey(), project.getName(), project.getDescription())).collect(Collectors.toList());
    }

    public List<DeploymentProject> getBambooSpecsPermittedDeploymentProjects() {
        return this.rssPermissionManager.getAccessibleDeploymentProjects(this.vcsRepositoryData.getId()).stream().map(projectId -> {
            try {
                return this.deploymentProjectService.getDeploymentProject(projectId.longValue());
            }
            catch (AccessDeniedException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<RepositoryDataEntity> getBambooSpecsPermittedRepositories() {
        return this.rssPermissionManager.getAccessibleRepositories(this.vcsRepositoryData.getId()).stream().map(vcsRepositoryId -> {
            try {
                return this.repositoryDefinitionManager.getRepositoryDataEntity(vcsRepositoryId.longValue());
            }
            catch (AccessDeniedException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public Map<String, String> getEditablePermissions() {
        return (Map)this.repositoryPermissionsService.supportedPermissions().stream().collect(BambooCollectors.toImmutableMap(PERMISSION_LABELS::get, BambooPermission::getName));
    }

    @NotNull
    public List<String> getPermissionDependencies(@NotNull String permissionName) {
        Permission permission = BambooPermission.buildFromName((String)permissionName);
        Preconditions.checkState((boolean)(permission instanceof BambooPermission));
        return this.repositoryPermissionsService.permissionDependencies((BambooPermission)permission).stream().map(BambooPermission::getName).collect(Collectors.toList());
    }

    @NotNull
    public String getBambooSpecsVersion() {
        return BambooSpecVersion.getModelVersion();
    }

    public boolean isShowSecuritySettingsHint() {
        return !this.administrationConfigurationAccessor.getAdministrationConfiguration().isUnauthenticatedRemoteTriggerAllowed();
    }

    @Nullable
    public String getDefaultBranch() {
        return this.vcsRepositoryData.getBranch() != null ? this.vcsRepositoryData.getBranch().getVcsBranch().getName() : null;
    }

    public boolean areDivergentBranchesSupported() {
        return this.vcsRepositoryManager.supportsDivergentBranches(this.vcsRepositoryData.getPluginKey());
    }
}

