/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.bamboo.configuration.repository.AbstractLinkedRepositoryAction;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.bamboo.ww2.aware.permissions.GlobalCreateRepositorySecurityAware;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class CreateLinkedRepository
extends AbstractLinkedRepositoryAction
implements GlobalCreateRepositorySecurityAware {
    private static final Logger log = Logger.getLogger(CreateLinkedRepository.class);
    private VcsUIConfigBean.VcsTypeSelector currentVcsTypeSelector;
    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> currentViewersSelectors;

    @Override
    public void prepare() throws Exception {
        super.prepare();
        this.prepareVcsAndViewersHtmls(TaskRenderMode.SUCCESS);
    }

    public String input() throws Exception {
        return "input";
    }

    public String execute() {
        try {
            this.vcsRepositoryData = this.vcsRepositoryConfigurationService.createLinkedRepository(this.vcsUIConfigBean.getPartialVcsConfigurationFromActionData(this.vcsRepositoryModuleDescriptor, this.repositoryName, StringUtils.defaultString((String)this.userDescription, (String)""), null, true, VcsConfigurationHelper.OVERRIDE_ALL), this.getUser(), VcsRepositoryConfigurationService.LinkedRepositoryAccess.ALL_USERS);
            this.repositoryId = this.vcsRepositoryData.getId();
        }
        catch (Exception e) {
            this.addActionError(e);
            return "error";
        }
        return "success";
    }

    public void validate() {
        this.validateRepositoryConfiguration();
        if (this.hasErrors()) {
            this.prepareVcsAndViewersHtmls(TaskRenderMode.ERROR);
        }
    }

    protected void prepareVcsAndViewersHtmls(TaskRenderMode renderMode) {
        if (this.vcsRepositoryModuleDescriptor != null) {
            this.currentVcsTypeSelector = this.prepareHtml(renderMode);
            this.currentViewersSelectors = this.prepareViewersHtml(renderMode);
        } else {
            this.currentVcsTypeSelector = this.vcsUIConfigBean.getNullRepositorySelector();
            this.currentViewersSelectors = Collections.singletonList(VcsViewerUIConfigBean.NO_VIEWER);
        }
    }

    private VcsUIConfigBean.VcsTypeSelector prepareHtml(@NotNull TaskRenderMode renderMode) {
        return new VcsUIConfigBean.VcsTypeSelector(this.vcsRepositoryModuleDescriptor, this.vcsUIConfigBean.prepareCreateHtmlFragments(this.vcsRepositoryModuleDescriptor, renderMode, null));
    }

    public VcsUIConfigBean.VcsTypeSelector getCurrentVcsTypeSelector() {
        return this.currentVcsTypeSelector;
    }

    private List<VcsViewerUIConfigBean.VcsViewerTypeSelector> prepareViewersHtml(@NotNull TaskRenderMode renderMode) {
        return this.vcsViewerUIConfigBean.getViewerOptionsForRepositoryType(this.currentVcsTypeSelector.getKey(), renderMode);
    }

    public List<VcsViewerUIConfigBean.VcsViewerTypeSelector> getViewerSelectors() {
        return this.currentViewersSelectors;
    }

    public String getSubmitAction() {
        return "createLinkedRepository";
    }
}

