/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.bamboo.configuration.repository.AbstractLinkedRepositoryAction;
import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.security.GlobalApplicationSecureObject;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.actions.build.admin.config.task.TaskRenderMode;
import com.atlassian.struts.Preparable;
import java.util.List;
import java.util.stream.Collectors;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureLinkedRepositories
extends AbstractLinkedRepositoryAction
implements Preparable {
    private List<VcsRepositoryModuleDescriptor> vcsRepositoryModuleDescriptors;
    private List<VcsUIConfigBean.VcsTypeSelector> vcsTypeSelectors;
    private List<? extends VcsRepositoryData> repositoryDefinitions;

    @Override
    public void prepare() throws Exception {
        if (!this.hasGlobalPermission((Permission)BambooPermission.CREATE_REPOSITORY) && !this.hasAdminOnAnyRepo()) {
            throw new AccessDeniedException(this.getText("config.security.insufficientPermissions"));
        }
    }

    private boolean hasAdminOnAnyRepo() {
        return !this.getRepositoryDefinitions().isEmpty();
    }

    @Override
    @Nullable
    public Object getSecuredDomainObject() {
        return GlobalApplicationSecureObject.INSTANCE;
    }

    private List<VcsUIConfigBean.VcsTypeSelector> createVcsTypeSelectors(@NotNull TaskRenderMode renderMode) {
        return this.vcsRepositoryModuleDescriptors.stream().map(moduleDescriptor -> new VcsUIConfigBean.VcsTypeSelector((VcsRepositoryModuleDescriptor)moduleDescriptor, VcsUIConfigBean.VcsHtmlFragments.emptyFragments())).collect(Collectors.toList());
    }

    private void initRepositoryTypeSelectors() {
        this.initVcsRepositoryModuleDescriptors();
        if (this.vcsTypeSelectors == null) {
            this.vcsTypeSelectors = this.createVcsTypeSelectors(TaskRenderMode.SUCCESS);
        }
    }

    private void initVcsRepositoryModuleDescriptors() {
        if (this.vcsRepositoryModuleDescriptors == null) {
            this.vcsRepositoryModuleDescriptors = this.vcsRepositoryManager.getAvailableStandaloneRepositoryDescriptors();
        }
    }

    public List<VcsUIConfigBean.VcsTypeSelector> getVcsTypeSelectors() {
        this.initRepositoryTypeSelectors();
        return this.vcsTypeSelectors;
    }

    public List<? extends VcsRepositoryData> getRepositoryDefinitions() {
        if (this.repositoryDefinitions == null) {
            this.repositoryDefinitions = this.cachedRepositoryDefinitionAccessor.getLinkedRepositoriesForAdministration();
        }
        return this.repositoryDefinitions;
    }
}

