/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.repository;

import com.atlassian.bamboo.configuration.repository.VcsUIConfigBean;
import com.atlassian.bamboo.configuration.repository.VcsViewerUIConfigBean;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.deployments.environments.DecoratedEnvironment;
import com.atlassian.bamboo.deployments.environments.EnvironmentComparators;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.repository.PermissionFilteringRepositoryDefinitionAccessor;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.specs.RssPermissionManager;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.configuration.PartialVcsRepositoryData;
import com.atlassian.bamboo.vcs.configuration.service.VcsConfigurationHelper;
import com.atlassian.bamboo.vcs.configuration.service.VcsRepositoryConfigurationService;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.build.admin.create.UIConfigSupport;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.opensymphony.webwork.dispatcher.json.JSONException;
import com.opensymphony.webwork.dispatcher.json.JSONObject;
import com.opensymphony.xwork2.Preparable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractLinkedRepositoryAction
extends BambooActionSupport
implements Preparable {
    @Autowired
    protected RepositoryDefinitionManager repositoryDefinitionManager;
    @Autowired
    protected PermissionFilteringRepositoryDefinitionAccessor cachedRepositoryDefinitionAccessor;
    @Autowired
    protected VcsRepositoryManager vcsRepositoryManager;
    @Autowired
    protected VcsUIConfigBean vcsUIConfigBean;
    @Autowired
    protected VcsRepositoryConfigurationService vcsRepositoryConfigurationService;
    @Autowired
    protected VcsViewerUIConfigBean vcsViewerUIConfigBean;
    @Autowired
    protected RssPermissionManager rssPermissionManager;
    @Autowired
    protected UIConfigSupport uiConfigSupport;
    @Autowired
    protected CustomVariableContext customVariableContext;
    @Autowired
    protected VariableSubstitutorFactory variableSubstitutorFactory;
    @Autowired
    private EnvironmentService environmentService;
    protected String selectedRepository;
    protected String selectedWebRepositoryViewer;
    protected String repositoryName;
    protected Long repositoryId;
    protected String userDescription;
    protected PartialVcsRepositoryData vcsRepositoryData;
    protected VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor;
    protected List<PlanIdentifier> planUsingRepository;
    private Integer hiddenPlansUsingRepositoryCount;
    protected List<DecoratedEnvironment> environmentUsingRepository;
    private Integer hiddenEnvironmentsUsingRepositoryCount;

    public void prepare() throws Exception {
        if (this.repositoryId == null) {
            this.repositoryId = 0L;
        } else if (this.repositoryId > 0L) {
            this.vcsRepositoryData = this.getRepositoryById(this.repositoryId);
            if (this.vcsRepositoryData != null && !this.vcsRepositoryData.isLinked()) {
                this.vcsRepositoryData = null;
            }
        }
        this.selectedWebRepositoryViewer = "none:none";
        if (this.vcsRepositoryData != null) {
            this.selectedRepository = this.vcsRepositoryData.getPluginKey();
            this.repositoryName = this.vcsRepositoryData.getName();
            this.userDescription = this.vcsRepositoryData.getDescription();
            String string = this.selectedWebRepositoryViewer = this.vcsRepositoryData.getViewerConfiguration() != null ? this.vcsRepositoryData.getViewerConfiguration().getPluginKey() : "none:none";
        }
        if (!StringUtils.isBlank((CharSequence)this.selectedRepository)) {
            this.vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(this.selectedRepository);
            if (this.vcsRepositoryData == null && this.vcsRepositoryModuleDescriptor != null) {
                this.selectedWebRepositoryViewer = this.vcsRepositoryModuleDescriptor.getDefaultVcsViewerKey();
            }
        }
    }

    @Override
    @NotNull
    public JSONObject getJsonObject() throws JSONException {
        JSONObject jsonObject = this.buildJsonObject();
        if (this.vcsRepositoryData != null) {
            JSONObject jsonRepositoryObject = new JSONObject();
            jsonRepositoryObject.put("id", this.vcsRepositoryData.getId());
            jsonRepositoryObject.put("name", (Object)this.vcsRepositoryData.getName());
            jsonRepositoryObject.put("description", (Object)this.vcsRepositoryData.getDescription());
            jsonRepositoryObject.put("position", 0);
            jsonRepositoryObject.put("global", this.vcsRepositoryData.isLinked());
            jsonObject.put("repositoryResult", (Object)jsonRepositoryObject);
        }
        return jsonObject;
    }

    protected void validateName() {
        this.checkFieldXssSafety("repositoryName", this.repositoryName);
        if (StringUtils.isBlank((CharSequence)this.repositoryName)) {
            this.addFieldError("repositoryName", this.getText("repository.name.not.set"));
        } else if (this.repositoryName.length() > 255) {
            this.addFieldError("repositoryName", this.getText("repository.shared.name.too.long", (List)ImmutableList.of((Object)255)));
        } else if (this.vcsRepositoryConfigurationService.validateLinkedRepositoryName(this.repositoryName, (BambooIdProvider)this.vcsRepositoryData)) {
            this.addFieldError("repositoryName", this.getText("repository.shared.name.already.exists"));
        }
    }

    protected void validateDescription() {
        this.checkFieldXssSafety("userDescription", this.userDescription);
    }

    @Nullable
    protected PartialVcsRepositoryData getRepositoryById(long id) {
        return this.repositoryDefinitionManager.getVcsRepositoryDataForEditing(this.repositoryId.longValue());
    }

    public List<PlanIdentifier> getPlanUsingRepository() {
        if (this.planUsingRepository == null) {
            List allPlans = this.repositoryDefinitionManager.getIdentifiersOfPlansUsingRepositoryOrItsDirectChildren(this.repositoryId.longValue());
            this.planUsingRepository = allPlans.stream().filter(arg_0 -> ((Predicate)this.bambooPermissionManager.hasPermission(BambooPermission.READ, null)).apply(arg_0)).sorted(Comparator.comparing(plan -> plan.getName().toLowerCase(Locale.getDefault()))).collect(Collectors.toList());
            this.hiddenPlansUsingRepositoryCount = allPlans.size() - this.planUsingRepository.size();
        }
        return this.planUsingRepository;
    }

    public int getHiddenPlansUsingRepositoryCount() {
        if (this.hiddenPlansUsingRepositoryCount == null) {
            this.getPlanUsingRepository();
        }
        return this.hiddenPlansUsingRepositoryCount;
    }

    public List<DecoratedEnvironment> getEnvironmentUsingRepository() {
        if (this.environmentUsingRepository == null) {
            List allEnvironments = this.environmentService.getEnvironmentsUsingRepositoryDataEntity(this.repositoryId.longValue());
            List viewableEnvironments = allEnvironments.stream().filter(e -> e.getOperations().isCanView()).map(this.environmentService.getEnvironmentDecorator()).sorted(EnvironmentComparators.byDeploymentProjectAndEnvironmentName()).collect(Collectors.toList());
            this.environmentUsingRepository = viewableEnvironments;
            this.hiddenEnvironmentsUsingRepositoryCount = allEnvironments.size() - viewableEnvironments.size();
        }
        return this.environmentUsingRepository;
    }

    public Integer getHiddenEnvironmentsUsingRepositoryCount() {
        if (this.hiddenEnvironmentsUsingRepositoryCount == null) {
            this.getEnvironmentUsingRepository();
        }
        return this.hiddenEnvironmentsUsingRepositoryCount;
    }

    public boolean isRepositoryDashboardOn() {
        return SystemProperty.GLOBAL_REPOSITORY_DASHBOARD.getTypedValue();
    }

    public Long getRepositoryId() {
        return this.repositoryId;
    }

    public void setRepositoryId(Long repositoryId) {
        this.repositoryId = repositoryId;
    }

    public String getSelectedRepository() {
        return this.selectedRepository;
    }

    public void setSelectedRepository(String selectedRepository) {
        this.selectedRepository = selectedRepository;
    }

    public String getSelectedWebRepositoryViewer() {
        return this.selectedWebRepositoryViewer;
    }

    public void setSelectedWebRepositoryViewer(String selectedWebRepositoryViewer) {
        this.selectedWebRepositoryViewer = selectedWebRepositoryViewer;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public void setUserDescription(String userDescription) {
        this.userDescription = userDescription;
    }

    public UIConfigSupport getUiConfigBean() {
        return this.uiConfigSupport;
    }

    public int getRepositoryNameMaxLength() {
        return 255;
    }

    protected void validateRepositoryConfiguration() {
        this.validateName();
        this.validateDescription();
        if (this.vcsRepositoryModuleDescriptor == null) {
            this.addActionError(this.getText("repository.shared.plugin.unavailable", Collections.singletonList(this.selectedRepository)));
        } else {
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForGlobalContext(), () -> this.lambda$validateRepositoryConfiguration$2((ErrorCollection)errorCollection));
            this.addErrorCollection((ErrorCollection)errorCollection);
        }
    }

    private /* synthetic */ void lambda$validateRepositoryConfiguration$2(ErrorCollection errorCollection) {
        this.vcsUIConfigBean.validateVcsConfiguration(this.vcsRepositoryModuleDescriptor, this.vcsRepositoryData, errorCollection, VcsConfigurationHelper.OVERRIDE_ALL);
    }
}

