/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.logs;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.configuration.logs.LoggingConfigEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ViewLog4jAction
extends GlobalAdminAction {
    private static final List<String> LEVEL_TYPES = Stream.of(Level.ALL, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL).map(Object::toString).collect(Collectors.toList());
    private List<LoggingConfigEntry> entries;

    public String execute() {
        this.setupEntries();
        return "success";
    }

    public String getExtraLevelName() {
        return Level.DEBUG.toString();
    }

    public List<String> getLevelTypes() {
        return LEVEL_TYPES;
    }

    public List<LoggingConfigEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<LoggingConfigEntry> entries) {
        this.entries = entries;
    }

    protected void setupEntries() {
        this.entries = Stream.concat(this.makeListOfExplicitLoggers().stream(), Stream.of(Logger.getRootLogger())).map(LoggingConfigEntry::fromLogger).collect(Collectors.toList());
    }

    private List<Logger> makeListOfExplicitLoggers() {
        Enumeration loggers = LogManager.getCurrentLoggers();
        ArrayList<Logger> listLoggers = new ArrayList<Logger>();
        while (loggers.hasMoreElements()) {
            Logger log = (Logger)loggers.nextElement();
            if (log.getLevel() == null) continue;
            listLoggers.add(log);
        }
        listLoggers.sort(Comparator.comparing(Category::getName));
        return listLoggers;
    }
}

