/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.logs;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LoggingConfigEntry
implements Comparable<LoggingConfigEntry> {
    private static final String ROOT = "root";
    private String clazz;
    private Level level;

    public boolean isRoot() {
        return this.clazz.equals(ROOT);
    }

    public LoggingConfigEntry(String clazz, Level level) {
        this.clazz = clazz;
        this.level = level;
    }

    public LoggingConfigEntry(String clazz, String level) {
        this.clazz = clazz;
        this.level = Level.toLevel((String)level);
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getLevel() {
        return this.level.toString();
    }

    public Level getLog4JLevel() {
        return this.level;
    }

    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    public void setLevel(String level) {
        this.level = Level.toLevel((String)level);
    }

    public static LoggingConfigEntry fromLogger(Logger logger) {
        return new LoggingConfigEntry(logger.getName(), logger.getLevel());
    }

    @Override
    public int compareTo(LoggingConfigEntry o) {
        return this.clazz.compareTo(o.getClazz());
    }
}

