/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.logs;

import com.atlassian.bamboo.configuration.logs.LoggingConfigEntry;
import com.atlassian.bamboo.configuration.logs.ViewLog4jAction;
import com.atlassian.core.util.ClassLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class ConfigureLog4jAction
extends ViewLog4jAction {
    private static final Logger log = Logger.getLogger(ConfigureLog4jAction.class);
    private static final String LOGLEVEL_DEFAULT = "loglevel.production";
    private static final Pattern VALID_LOGGER_NAME_PATTERN = Pattern.compile("([_\\p{L}0-9]*.)*[_\\p{L}0-9]");
    private String className;
    private String levelName;
    private String extraClassName;
    private String extraLevelName;
    private String toDeleteName;
    private String profileName;

    public String delete() {
        if (this.toDeleteName.equals("root")) {
            this.addActionError("You cannot delete the root logger");
            this.setupEntries();
            return "error";
        }
        LogManager.getLogger((String)this.toDeleteName).setLevel(null);
        return "success";
    }

    public String save() {
        this.setLevelForLogger(this.className, this.levelName);
        return "success";
    }

    public String add() {
        if (StringUtils.isBlank((CharSequence)this.extraClassName) || !this.isValidLoggerName(this.extraClassName)) {
            this.addActionError("Please specify a valid name for the logger");
            this.setupEntries();
            return "error";
        }
        this.setLevelForLogger(this.extraClassName, this.extraLevelName);
        log.debug((Object)("New logger [ " + this.extraClassName + " ] saved"));
        return "success";
    }

    public void setToDeleteName(String toDeleteName) {
        this.toDeleteName = toDeleteName;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public void setExtraClassName(String extraClassName) {
        this.extraClassName = extraClassName;
    }

    public void setExtraLevelName(String extraLevelName) {
        this.extraLevelName = extraLevelName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String changeProfile() {
        InputStream propStream = ClassLoaderUtils.getResourceAsStream((String)this.getPropertiesResource(this.profileName), ConfigureLog4jAction.class);
        if (propStream == null) {
            return this.handleError();
        }
        Properties props = new Properties();
        try {
            props.load(propStream);
        }
        catch (IOException e) {
            return this.handleError();
        }
        LogManager.resetConfiguration();
        PropertyConfigurator.configure((Properties)props);
        return "success";
    }

    public boolean isPermitted() {
        return true;
    }

    private String getPropertiesResource(String profileName) {
        if (this.getText(LOGLEVEL_DEFAULT).equals(profileName) || StringUtils.isEmpty((CharSequence)profileName)) {
            return "log4j.properties";
        }
        return "log4j-" + profileName.toLowerCase() + ".properties";
    }

    private String handleError() {
        this.addActionError("Unable to load properties for profile : " + this.profileName);
        this.setupEntries();
        return "error";
    }

    private void setLevelForLogger(String className, String levelName) {
        LoggingConfigEntry configEntry = new LoggingConfigEntry(className, levelName);
        if (configEntry.isRoot()) {
            LogManager.getRootLogger().setLevel(configEntry.getLog4JLevel());
        } else {
            LogManager.getLogger((String)configEntry.getClazz()).setLevel(configEntry.getLog4JLevel());
        }
    }

    private boolean isValidLoggerName(String extraClassName) {
        return VALID_LOGGER_NAME_PATTERN.matcher(extraClassName).matches();
    }
}

