/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.credentials;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.configuration.credentials.CredentialsRenderMode;
import com.atlassian.bamboo.configuration.credentials.CredentialsUIConfigBean;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.Preparable;
import java.util.Map;

public class EditSharedCredentials
extends GlobalAdminAction
implements Preparable {
    private static final String INVALID_PLUGIN = "invalidPlugin";
    private long credentialsId;
    private String credentialsName;
    private String editHtml;
    private CredentialsData credentials;
    private CredentialTypeModuleDescriptor credentialDescriptor;
    private CredentialsManager credentialsManager;
    private CredentialsUIConfigBean credentialsUIConfigBean;

    public void prepare() throws Exception {
        this.credentials = this.credentialsManager.getCredentials(this.credentialsId);
        if (this.credentials != null) {
            this.credentialDescriptor = this.credentialsManager.getCredentialTypeDescriptor(this.credentials.getPluginKey());
        }
    }

    public String input() throws Exception {
        if (this.hasErrors()) {
            return "error";
        }
        if (this.credentials == null) {
            this.addActionError(this.getText("sharedCredentials.edit.error.incorrectId", Lists.newArrayList((Object[])new Long[]{this.credentialsId})));
            return "error";
        }
        if (this.credentialDescriptor == null) {
            this.addActionError(this.getText("sharedCredentials.edit.error.missingPlugin", Lists.newArrayList((Object[])new String[]{this.credentials.getPluginKey()})));
            return INVALID_PLUGIN;
        }
        this.editHtml = this.credentialsUIConfigBean.prepareEditHtml(this.credentialDescriptor, this.credentials, CredentialsRenderMode.SUCCESS);
        this.credentialsName = this.credentials.getName();
        return "input";
    }

    public void validate() {
        this.checkFieldXssSafety("credentialsName", this.credentialsName);
        this.validateUniqueName();
        if (this.credentials == null) {
            this.addActionError(this.getText("sharedCredentials.edit.error.incorrectId", Lists.newArrayList((Object[])new Long[]{this.credentialsId})));
        } else if (this.credentialDescriptor == null) {
            this.addActionError(this.getText("sharedCredentials.edit.error.missingPlugin", Lists.newArrayList((Object[])new String[]{this.credentials.getPluginKey()})));
        } else {
            this.credentialsUIConfigBean.validateCredentialsConfiguration(this.credentialDescriptor, this.credentials, this);
            if (this.hasErrors()) {
                this.editHtml = this.credentialsUIConfigBean.prepareEditHtml(this.credentialDescriptor, this.credentials, CredentialsRenderMode.ERROR);
            }
        }
    }

    public String execute() throws Exception {
        try {
            Map<String, String> credentialsConfig = this.credentialsUIConfigBean.getCredentialsConfigurationMap(this.credentialDescriptor, this.credentials);
            this.credentialsManager.editCredentials(this.credentialsId, this.credentialsName, credentialsConfig);
            return "success";
        }
        catch (IllegalArgumentException e) {
            this.addActionError(e);
            return "error";
        }
    }

    private void validateUniqueName() {
        CredentialsData existingCredentials = this.credentialsManager.getCredentialsByName(this.credentialsName);
        if (existingCredentials != null && this.credentialsId != this.credentials.getId()) {
            this.addFieldError("credentialsName", this.getText("sharedCredentials.error.nonUniqueName"));
        }
    }

    public String getCredentialsName() {
        return this.credentialsName;
    }

    public void setCredentialsName(String credentialsName) {
        this.credentialsName = credentialsName;
    }

    public long getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(long credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getEditHtml() {
        return this.editHtml;
    }

    public void setCredentialsManager(CredentialsManager credentialsManager) {
        this.credentialsManager = credentialsManager;
    }

    public void setCredentialsUIConfigBean(CredentialsUIConfigBean credentialsUIConfigBean) {
        this.credentialsUIConfigBean = credentialsUIConfigBean;
    }

    public String getCredentialsType() {
        return this.credentialDescriptor.getName();
    }
}

