/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.credentials;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.credentials.CredentialsUsageDetector;
import com.atlassian.bamboo.credentials.SharedCredentialsInEnvironments;
import com.atlassian.bamboo.credentials.SharedCredentialsInJobs;
import com.atlassian.bamboo.credentials.SharedCredentialsInRepositories;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteSharedCredentials
extends GlobalAdminAction {
    protected long credentialsId;
    private Map<VcsRepositoryData, String> globalRepositoryDefinitionsMap;
    private Map<VcsRepositoryData, String> planRepositoryDefinitionsMap;
    private Map<VcsRepositoryData, String> planBranchRepositoryDefinitionsMap;
    private Map<String, String> buildTaskDefinitionsMap;
    private Map<String, Long> deploymentTaskDefinitionsMap;
    @Autowired
    protected CredentialsManager credentialsManager;
    @Autowired
    private CredentialsUsageDetector credentialsUsageDetector;

    public String execute() throws Exception {
        this.credentialsManager.deleteCredentials(this.credentialsId);
        return "success";
    }

    public String confirm() {
        this.prepareGlobalRepositoryDefinitions();
        this.preparePlanAndBranchRepositoryDefinitions();
        this.prepareBuildTaskDefinitions();
        this.prepareDeploymentTaskDefinitions();
        return "success";
    }

    private void prepareGlobalRepositoryDefinitions() {
        this.globalRepositoryDefinitionsMap = new HashMap<VcsRepositoryData, String>();
        List globalRepositoriesWithSharedCredentials = this.credentialsUsageDetector.getGlobalRepositoriesWithSharedCredentials(Long.valueOf(this.credentialsId));
        globalRepositoriesWithSharedCredentials.forEach(r -> {
            String cfr_ignored_0 = this.globalRepositoryDefinitionsMap.put((VcsRepositoryData)r, (String)null);
        });
    }

    private void preparePlanAndBranchRepositoryDefinitions() {
        this.planRepositoryDefinitionsMap = new HashMap<VcsRepositoryData, String>();
        this.planBranchRepositoryDefinitionsMap = new HashMap<VcsRepositoryData, String>();
        SharedCredentialsInRepositories credentialsInAllRepositories = this.credentialsUsageDetector.getCredentialsInAllRepositories(Long.valueOf(this.credentialsId));
        credentialsInAllRepositories.getPlanRepositories().forEach((k, v) -> v.forEach(r -> this.planRepositoryDefinitionsMap.put((VcsRepositoryData)r, k.getPlanKey().toString())));
        credentialsInAllRepositories.getPlanBranchRepositories().forEach((k, v) -> v.forEach(r -> this.planBranchRepositoryDefinitionsMap.put((VcsRepositoryData)r, k.getPlanKey().toString())));
    }

    private void prepareBuildTaskDefinitions() {
        this.buildTaskDefinitionsMap = new HashMap<String, String>();
        SharedCredentialsInJobs credentialsInAllPlans = this.credentialsUsageDetector.getCredentialsInAllPlans(Long.valueOf(this.credentialsId));
        credentialsInAllPlans.getJobsWithSharedCredentials().forEach(job -> this.buildTaskDefinitionsMap.put(job.getParent().getName(), job.getPlanKey().toString()));
    }

    private void prepareDeploymentTaskDefinitions() {
        this.deploymentTaskDefinitionsMap = new HashMap<String, Long>();
        SharedCredentialsInEnvironments credentialsInAllEnvironments = this.credentialsUsageDetector.getCredentialsInAllEnvironments(Long.valueOf(this.credentialsId));
        credentialsInAllEnvironments.getEnvironmentsWithSharedCredentials().forEach(env -> this.deploymentTaskDefinitionsMap.put(env.getName(), env.getId()));
    }

    public Map<VcsRepositoryData, String> getGlobalRepositoryDefinitionsMap() {
        return this.globalRepositoryDefinitionsMap;
    }

    public Map<VcsRepositoryData, String> getPlanRepositoryDefinitionsMap() {
        return this.planRepositoryDefinitionsMap;
    }

    public Map<VcsRepositoryData, String> getPlanBranchRepositoryDefinitionsMap() {
        return this.planBranchRepositoryDefinitionsMap;
    }

    public Map<String, String> getBuildTaskDefinitionsMap() {
        return this.buildTaskDefinitionsMap;
    }

    public Map<String, Long> getDeploymentTaskDefinitionsMap() {
        return this.deploymentTaskDefinitionsMap;
    }

    public long getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(long credentialsId) {
        this.credentialsId = credentialsId;
    }
}

