/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.credentials;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.configuration.credentials.CredentialsRenderMode;
import com.atlassian.bamboo.credentials.CredentialType;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.web.utils.ActionParamHandlingUtils;
import com.atlassian.bamboo.webwork.util.ActionParametersMapImpl;
import com.atlassian.plugin.elements.ResourceLocation;
import com.opensymphony.xwork2.ActionContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@Internal
public class CredentialsUIConfigBean {
    @Autowired
    private TemplateRenderer templateRenderer;

    public void validateCredentialsConfiguration(@NotNull CredentialTypeModuleDescriptor credentialDescriptor, @Nullable CredentialsData previousCredentialsData, @NotNull ErrorCollection errorCollection) {
        CredentialType credentialType = (CredentialType)credentialDescriptor.getModule();
        credentialType.validate((ActionParametersMap)new ActionParametersMapImpl(ActionContext.getContext(), true), previousCredentialsData, errorCollection);
    }

    @NotNull
    public String prepareCreateHtml(@NotNull CredentialTypeModuleDescriptor credentialDescriptor, @NotNull CredentialsRenderMode renderMode) {
        CredentialType credentialType = (CredentialType)credentialDescriptor.getModule();
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        credentialType.populateContextForCreate(contextParams);
        return this.renderEditHtml(credentialDescriptor, contextParams, renderMode);
    }

    @NotNull
    public String prepareEditHtml(@NotNull CredentialTypeModuleDescriptor credentialDescriptor, @NotNull CredentialsData credentialsData, @NotNull CredentialsRenderMode renderMode) {
        CredentialType credentialType = (CredentialType)credentialDescriptor.getModule();
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        credentialType.populateContextForEdit(contextParams, credentialsData);
        return this.renderEditHtml(credentialDescriptor, contextParams, renderMode);
    }

    @NotNull
    public Map<String, String> getCredentialsConfigurationMap(@NotNull CredentialTypeModuleDescriptor credentialDescriptor, @Nullable CredentialsData previousCredentialsData) {
        CredentialType credentialType = (CredentialType)credentialDescriptor.getModule();
        if (credentialType != null) {
            ActionParametersMapImpl actionParametersMap = new ActionParametersMapImpl(ActionContext.getContext(), true);
            return credentialType.generateCredentialsConfigMap((ActionParametersMap)actionParametersMap, previousCredentialsData);
        }
        return new HashMap<String, String>();
    }

    @NotNull
    private String renderEditHtml(@NotNull CredentialTypeModuleDescriptor credentialDescriptor, @NotNull Map<String, Object> contextParams, CredentialsRenderMode renderMode) {
        if (renderMode == CredentialsRenderMode.ERROR) {
            ActionParamHandlingUtils.appendContextTo(contextParams);
        }
        OgnlStackUtils.putAll(contextParams);
        ResourceLocation resourceLocation = credentialDescriptor.getResourceLocation("freemarker", "edit");
        if (resourceLocation != null) {
            String templatePath = resourceLocation.getLocation();
            String html = this.templateRenderer.render(templatePath, contextParams);
            return StringUtils.defaultString((String)html, (String)"");
        }
        return "";
    }
}

