/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.credentials;

import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.credentials.CredentialTypeModuleDescriptor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.credentials.CredentialsManager;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.util.BambooIterables;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ConfigureSharedCredentials
extends GlobalAdminAction {
    private CredentialsManager credentialsManager;
    private List<CredentialTypeModuleDescriptor> credentialTypes;
    private Iterable<CredentialsData> credentials;

    public Iterable<CredentialTypeModuleDescriptor> getCredentialTypes() {
        if (this.credentialTypes == null) {
            this.credentialTypes = this.credentialsManager.getCredentialTypeDescriptors();
        }
        return this.credentialTypes;
    }

    public Iterable<CredentialsData> getCredentials(@NotNull String pluginKey) {
        if (this.credentials == null) {
            this.credentials = this.credentialsManager.getAllCredentials();
        }
        return BambooIterables.stream(this.credentials).filter(BambooPluginUtils.pluginKeyEquals((String)pluginKey)).collect(Collectors.toList());
    }

    public Iterable<CredentialsData> getAllCredentials() {
        if (this.credentials == null) {
            this.credentials = this.credentialsManager.getAllCredentials();
        }
        return this.credentials;
    }

    public void setCredentialsManager(CredentialsManager credentialsManager) {
        this.credentialsManager = credentialsManager;
    }
}

