/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.capability.CapabilitySetProvider;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityMatchResult;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementsMatcher;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.DecoratedCapabilityRequirement;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirementSet;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.struts.TextProvider;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewRejectedRequirements
extends BambooActionSupport {
    private static final Logger log = Logger.getLogger(ViewRejectedRequirements.class);
    private long agentId;
    private long environmentId;
    private long imageConfigurationId;
    private long jobId;
    private PipelineDefinition buildAgent;
    private ElasticImageConfiguration elasticImageConfiguration;
    private Environment environment;
    private Job job;
    private AgentManager agentManager;
    @Autowired
    private EnvironmentService environmentService;
    private CapabilityHelper capabilityHelper;
    private ElasticImageConfigurationManager elasticImageConfigurationManager;
    private CapabilitySetManager capabilitySetManager;
    private CapabilityRequirementsMatcher capabilityRequirementsMatcher;
    private List<DecoratedCapabilityRequirement> rejectedRequirements;

    @Override
    public String doDefault() {
        ImageCapabilitySet readOnlyCapabilitySet;
        ImmutableRequirementSet requirementSet;
        if (this.environmentId > 0L) {
            this.environment = this.environmentService.getEnvironment(this.environmentId);
            if (this.environment == null) {
                this.addActionError("Could not find a environment with id " + this.environmentId);
                return "error";
            }
            requirementSet = this.environment.getRequirementSet();
        } else if (this.jobId > 0L) {
            this.job = (Job)this.planManager.getPlanById(this.jobId, Job.class);
            if (this.job == null) {
                this.addActionError("Could not find a job with id " + this.jobId);
                return "error";
            }
            requirementSet = this.job.getRequirementSet();
        } else {
            this.addActionError("Please specify either a job id or an environment id");
            return "error";
        }
        if (this.agentId > 0L) {
            BuildAgent agent = this.agentManager.getAgent(this.agentId);
            if (agent == null) {
                this.addActionError("Could not find a build agent with id " + this.agentId);
                return "error";
            }
            this.buildAgent = agent.getDefinition();
            CapabilitySet agentCapabilitySet = CapabilitySetProvider.getAgentCapabilitySet((PipelineDefinition)this.buildAgent);
            readOnlyCapabilitySet = this.capabilitySetManager.getCombinedCapabilitySet(agentCapabilitySet);
        } else if (this.imageConfigurationId > 0L) {
            this.elasticImageConfiguration = this.elasticImageConfigurationManager.getElasticImageConfigurationById(this.imageConfigurationId);
            if (this.elasticImageConfiguration == null) {
                this.addActionError("Could not find a elastic image with id " + this.imageConfigurationId);
                return "error";
            }
            readOnlyCapabilitySet = this.elasticImageConfiguration.getCapabilitySet();
        } else {
            this.addActionError("please specify and Agent Id or image configuration id");
            return "error";
        }
        CapabilityMatchResult capabilityMatchResult = this.capabilityRequirementsMatcher.matchesWithResult((ReadOnlyCapabilitySet)readOnlyCapabilitySet, requirementSet);
        CapabilityRequirementSetDecorator capabilityRequirementSetDecorator = new CapabilityRequirementSetDecorator(capabilityMatchResult.getRejectedRequirements(), (TextProvider)this, this.capabilityHelper);
        this.rejectedRequirements = capabilityRequirementSetDecorator.getDecoratedObjects();
        return "input";
    }

    public long getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(long environmentId) {
        this.environmentId = environmentId;
    }

    public long getJobId() {
        return this.jobId;
    }

    public void setJobId(long jobId) {
        this.jobId = jobId;
    }

    public long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(long agentId) {
        this.agentId = agentId;
    }

    public long getImageConfigurationId() {
        return this.imageConfigurationId;
    }

    public void setImageConfigurationId(long imageConfigurationId) {
        this.imageConfigurationId = imageConfigurationId;
    }

    public PipelineDefinition getBuildAgent() {
        return this.buildAgent;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Job getJob() {
        return this.job;
    }

    public ElasticImageConfiguration getElasticImageConfiguration() {
        return this.elasticImageConfiguration;
    }

    public List<DecoratedCapabilityRequirement> getRejectedRequirements() {
        return this.rejectedRequirements;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setCapabilityHelper(CapabilityHelper capabilityHelper) {
        this.capabilityHelper = capabilityHelper;
    }

    public void setElasticImageConfigurationManager(ElasticImageConfigurationManager elasticImageConfigurationManager) {
        this.elasticImageConfigurationManager = elasticImageConfigurationManager;
    }

    public void setCapabilitySetManager(CapabilitySetManager capabilitySetManager) {
        this.capabilitySetManager = capabilitySetManager;
    }

    public void setCapabilityRequirementsMatcher(CapabilityRequirementsMatcher capabilityRequirementsMatcher) {
        this.capabilityRequirementsMatcher = capabilityRequirementsMatcher;
    }
}

