/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.manager.ExecutableAgentsMatrix;
import com.atlassian.bamboo.buildqueue.manager.RemoteAgentManager;
import com.atlassian.bamboo.configuration.agent.elastic.ElasticAgentOnImagePredicate;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.util.AgentComparator;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalBuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirementSet;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.actions.admin.elastic.ElasticUIBean;
import com.atlassian.bamboo.ww2.aware.TabSelectionAware;
import com.atlassian.bamboo.ww2.aware.permissions.AuthenticatedUserSecurityAware;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewAgents
extends BambooActionSupport
implements TabSelectionAware,
AuthenticatedUserSecurityAware {
    private static final Logger log = Logger.getLogger(ViewAgents.class);
    protected AgentManager agentManager;
    private ExecutableAgentsHelper executableAgentsHelper;
    private RemoteAgentManager remoteAgentManager;
    private ElasticInstanceManager elasticInstanceManager;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    private ElasticImageConfigurationManager elasticImageConfigurationManager;
    @Autowired
    private EnvironmentService environmentService;
    private ElasticUIBean elasticUIBean;
    private String selectedTab = "";
    private final AgentComparator AGENT_COMPARATOR = new AgentComparator();
    private String planKey;
    private LazyReference<ImmutableJob> plan = new LazyReference<ImmutableJob>(){

        @Nullable
        protected ImmutableJob create() throws Exception {
            if (ViewAgents.this.planKey != null) {
                return (ImmutableJob)Narrow.to((Object)ViewAgents.this.cachedPlanManager.getPlanByKey(PlanKeys.getPlanKey((String)ViewAgents.this.planKey)), ImmutableJob.class);
            }
            return null;
        }
    };
    private long environmentId;
    private LazyReference<Environment> environment = new LazyReference<Environment>(){

        @Nullable
        protected Environment create() throws Exception {
            if (ViewAgents.this.environmentId > 0L) {
                return ViewAgents.this.environmentService.getEnvironment(ViewAgents.this.environmentId);
            }
            return null;
        }
    };
    private final LazyReference<ExecutableAgentsMatrix> executableAgentsMatrix = new LazyReference<ExecutableAgentsMatrix>(){

        @Nullable
        protected ExecutableAgentsMatrix create() throws Exception {
            if (ViewAgents.this.planKey != null && ViewAgents.this.plan.get() != null) {
                ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery((MinimalRequirementSet)((ImmutableJob)ViewAgents.this.plan.get()).getEffectiveRequirementSet(), (AgentAssignmentService.AgentAssignmentExecutable)AgentAssignmentServiceHelper.asExecutable((ImmutableBuildable)((ImmutableBuildable)ViewAgents.this.plan.get()))).withDisabledIncluded().withOfflineIncluded();
                return ViewAgents.this.executableAgentsHelper.getExecutableAgentsMatrix(executorQuery);
            }
            if (ViewAgents.this.environmentId > 0L && ViewAgents.this.environment.get() != null) {
                ImmutableRequirementSet requirementSet = ((Environment)ViewAgents.this.environment.get()).getRequirementSet();
                ExecutableAgentsHelper.ExecutorQuery executorQuery = ExecutableAgentsHelper.ExecutorQuery.newQuery((ImmutableRequirementSet)requirementSet, (AgentAssignmentService.AgentAssignmentExecutable)AgentAssignmentServiceHelper.environmentToExecutable((long)ViewAgents.this.environmentId, (long)((Environment)ViewAgents.this.environment.get()).getDeploymentProjectId())).withDisabledIncluded().withOfflineIncluded();
                return ViewAgents.this.executableAgentsHelper.getExecutableAgentsMatrix(executorQuery);
            }
            return null;
        }
    };
    private final LazyReference<AgentCollections> agentCollections = new LazyReference<AgentCollections>(){

        protected AgentCollections create() throws Exception {
            return new AgentCollections();
        }
    };

    protected boolean validateInputKey() {
        if (this.planKey != null && this.plan.get() == null) {
            this.addActionError(this.getText("agents.view.error.plan.notfound", Collections.singletonList(this.planKey)));
            return false;
        }
        if (this.environmentId > 0L && this.environment.get() == null) {
            this.addActionError(this.getText("agents.view.error.environment.notfound", Collections.singletonList(String.valueOf(this.environmentId))));
            return false;
        }
        if (this.plan.get() != null && !this.hasPlanPermission(BambooPermission.WRITE.getName(), (PlanIdentifier)this.plan.get())) {
            this.addActionError(this.getText("agents.view.error.plan.no.permissions", Collections.singletonList(this.planKey)));
            return false;
        }
        if (this.environment.get() != null && !((Environment)this.environment.get()).getOperations().isCanEdit()) {
            this.addActionError(this.getText("agents.view.error.environment.no.permissions", Collections.singletonList(String.valueOf(this.environmentId))));
            return false;
        }
        return true;
    }

    @Override
    public String doDefault() throws Exception {
        if (!this.validateInputKey()) {
            return "error";
        }
        return super.doDefault();
    }

    public List<LocalBuildAgent> getLocalAgents() {
        return ((AgentCollections)this.agentCollections.get()).getLocalAgents();
    }

    public List<BuildAgent> getOnlineRemoteAgents() {
        return ((AgentCollections)this.agentCollections.get()).getOnlineRemoteAgents();
    }

    public List<BuildAgent> getOfflineRemoteAgents() {
        return ((AgentCollections)this.agentCollections.get()).getOfflineRemoteAgents();
    }

    public List<ElasticImageConfiguration> getElasticImageConfigurations() {
        return ((AgentCollections)this.agentCollections.get()).getElasticImageConfigurations();
    }

    public List<BuildAgent> getDedicatedNonMatchingAgents() {
        return ((AgentCollections)this.agentCollections.get()).getDedicatedNonMatchingAgents();
    }

    public List<ElasticImageConfiguration> getDedicatedNonMatchingElasticConfiguration() {
        return ((AgentCollections)this.agentCollections.get()).getDedicatedNonMatchingElasticConfiguration();
    }

    public ElasticUIBean getElasticUIBean() {
        return this.elasticUIBean;
    }

    public void setElasticUIBean(ElasticUIBean elasticUIBean) {
        this.elasticUIBean = elasticUIBean;
    }

    public boolean isAllowNewLocalAgent() {
        return this.agentManager.allowNewLocalAgent();
    }

    public boolean isAllowNewRemoteAgent() {
        return this.agentManager.allowNewRemoteAgent();
    }

    public int getNumberOfOnlineRemoteAgents() {
        return ((AgentCollections)this.agentCollections.get()).getOnlineRemoteAgents().size();
    }

    public int getNumberOfOnlineElasticAgents() {
        if (((AgentCollections)this.agentCollections.get()).getOnlineMatchingElasticAgentsSize() != -1) {
            return ((AgentCollections)this.agentCollections.get()).getOnlineMatchingElasticAgentsSize();
        }
        return this.agentManager.getOnlineElasticAgents().size();
    }

    public int getNumberOfRequestedElasticAgents() {
        return this.elasticInstanceManager.getTotalNumElasticRemoteAgents() - this.agentManager.getOnlineElasticAgents().size();
    }

    public int getAllowedNumberOfLocalAgents() {
        return this.getBambooLicenseManager().getAllowedNumberOfLocalAgents();
    }

    public int getAllowedNumberOfRemoteAgents() {
        return this.getBambooLicenseManager().getAllowedNumberOfRemoteAgents();
    }

    public List<String> getRemoteAgentLog() {
        return this.remoteAgentManager.getRemoteAgentLog();
    }

    public boolean isRemoteAgentFunctionEnabled() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().isRemoteAgentFunctionEnabled();
    }

    public boolean isRemoteAgentAuthenticationEnabled() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().isRemoteAgentAuthenticationEnabled();
    }

    public boolean isSecurityTokenRequiredFromAgents() {
        return this.administrationConfigurationAccessor.getAdministrationConfiguration().isSecurityTokenRequiredFromAgents();
    }

    public boolean isElasticBambooEnabled() {
        return this.elasticFunctionalityFacade.isElasticSupportEnabled();
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setRemoteAgentManager(RemoteAgentManager remoteAgentManager) {
        this.remoteAgentManager = remoteAgentManager;
    }

    public void setElasticAgentManager(ElasticInstanceManager elasticInstanceManager) {
        this.elasticInstanceManager = elasticInstanceManager;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    public void setElasticImageConfigurationManager(ElasticImageConfigurationManager elasticImageConfigurationManager) {
        this.elasticImageConfigurationManager = elasticImageConfigurationManager;
    }

    public void setExecutableAgentsHelper(ExecutableAgentsHelper executableAgentsHelper) {
        this.executableAgentsHelper = executableAgentsHelper;
    }

    public String getPlanKey() {
        return this.planKey;
    }

    public void setPlanKey(String planKey) {
        this.planKey = planKey;
    }

    public ImmutableJob getPlan() {
        return (ImmutableJob)this.plan.get();
    }

    public long getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(long environmentId) {
        this.environmentId = environmentId;
    }

    public Environment getEnvironment() {
        return (Environment)this.environment.get();
    }

    public String getElasticEnabledTextKey() {
        if (this.planKey != null) {
            return "agent.remote.numberOnline.elasticEnabled.matching";
        }
        return "agent.remote.numberOnline.elasticEnabled";
    }

    public String getOnlyElasticOnlineTextKey() {
        if (this.planKey != null) {
            return "agent.remote.numberOnline.elasticEnabled.onlyElasticOnline.matching";
        }
        return "agent.remote.numberOnline.elasticEnabled.onlyElasticOnline";
    }

    public String getNoElasticOnlineTextKey() {
        if (this.planKey != null) {
            return "agent.remote.numberOnline.elasticEnabled.noElasticOnline.matching";
        }
        return "agent.remote.numberOnline.elasticEnabled.noElasticOnline";
    }

    @Override
    @NotNull
    public String getSelectedTab() {
        return this.selectedTab;
    }

    @Override
    public void setSelectedTab(@NotNull String label) {
        this.selectedTab = label;
    }

    private class AgentCollections {
        private final List<BuildAgent> onlineRemoteAgents = new ArrayList<BuildAgent>();
        private final List<BuildAgent> offlineRemoteAgents = new ArrayList<BuildAgent>();
        private List<LocalBuildAgent> localAgents;
        private List<ElasticImageConfiguration> elasticImageConfigurations;
        private List<BuildAgent> dedicatedNonMatchingAgents = new ArrayList<BuildAgent>();
        private List<ElasticImageConfiguration> dedicatedNonMatchingElasticConfiguration = new ArrayList<ElasticImageConfiguration>();
        private int onlineMatchingElasticAgentsSize = -1;

        AgentCollections() {
            List remoteAgents;
            if (ViewAgents.this.plan.get() == null && ViewAgents.this.environment.get() == null) {
                this.elasticImageConfigurations = ViewAgents.this.elasticImageConfigurationManager.getAllElasticImageConfigurationsForCurrentRegion();
                this.localAgents = ViewAgents.this.agentManager.getAllLocalAgents();
                remoteAgents = ViewAgents.this.agentManager.getAllRemoteAgents();
            } else {
                if (!ViewAgents.this.validateInputKey()) {
                    return;
                }
                this.localAgents = new ArrayList<LocalBuildAgent>();
                remoteAgents = new ArrayList();
                for (final BuildAgent agent : Iterables.concat((Iterable)((ExecutableAgentsMatrix)ViewAgents.this.executableAgentsMatrix.get()).getBuildAgents(), (Iterable)((ExecutableAgentsMatrix)ViewAgents.this.executableAgentsMatrix.get()).getDedicatedNonMatchingBuildAgents())) {
                    agent.accept(new BuildAgent.BuildAgentVisitor(){

                        public void visitLocal(LocalBuildAgent localBuildAgent) {
                            AgentCollections.this.localAgents.add(localBuildAgent);
                        }

                        public void visitRemote(BuildAgent remoteBuildAgent) {
                            remoteAgents.add(agent);
                        }
                    });
                }
                this.elasticImageConfigurations = new ArrayList<ElasticImageConfiguration>(((ExecutableAgentsMatrix)ViewAgents.this.executableAgentsMatrix.get()).getImageMatches());
                this.elasticImageConfigurations.addAll(((ExecutableAgentsMatrix)ViewAgents.this.executableAgentsMatrix.get()).getDedicatedNonMatchingImages());
                Collection onlineMatchingElasticAgents = Collections2.filter((Collection)ViewAgents.this.agentManager.getOnlineElasticAgents(), (Predicate)new ElasticAgentOnImagePredicate(this.elasticImageConfigurations));
                this.onlineMatchingElasticAgentsSize = onlineMatchingElasticAgents.size();
                this.onlineRemoteAgents.addAll(onlineMatchingElasticAgents);
                this.dedicatedNonMatchingAgents = new ArrayList<BuildAgent>(((ExecutableAgentsMatrix)ViewAgents.this.executableAgentsMatrix.get()).getDedicatedNonMatchingBuildAgents());
                this.dedicatedNonMatchingElasticConfiguration = ((ExecutableAgentsMatrix)ViewAgents.this.executableAgentsMatrix.get()).getDedicatedNonMatchingImages();
            }
            for (final BuildAgent agent : remoteAgents) {
                if (agent.isActive()) {
                    this.onlineRemoteAgents.add(agent);
                    continue;
                }
                this.offlineRemoteAgents.add(agent);
            }
            Collections.sort(this.localAgents, ViewAgents.this.AGENT_COMPARATOR);
            Collections.sort(this.onlineRemoteAgents, ViewAgents.this.AGENT_COMPARATOR);
            Collections.sort(this.offlineRemoteAgents, ViewAgents.this.AGENT_COMPARATOR);
        }

        @NotNull
        public List<BuildAgent> getOnlineRemoteAgents() {
            return this.onlineRemoteAgents;
        }

        @NotNull
        public List<BuildAgent> getOfflineRemoteAgents() {
            return this.offlineRemoteAgents;
        }

        @NotNull
        public List<LocalBuildAgent> getLocalAgents() {
            return this.localAgents;
        }

        public List<ElasticImageConfiguration> getElasticImageConfigurations() {
            return this.elasticImageConfigurations;
        }

        public int getOnlineMatchingElasticAgentsSize() {
            return this.onlineMatchingElasticAgentsSize;
        }

        public List<BuildAgent> getDedicatedNonMatchingAgents() {
            return this.dedicatedNonMatchingAgents;
        }

        public List<ElasticImageConfiguration> getDedicatedNonMatchingElasticConfiguration() {
            return this.dedicatedNonMatchingElasticConfiguration;
        }
    }
}

