/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentMap;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.capability.CapabilitySetProvider;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.CallableResultCache;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.predicates.BuildAgentPredicates;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelperImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityMatchResult;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementsMatcher;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManagerUtils;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.atlassian.bamboo.v2.build.agent.capability.MinimalRequirementSet;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.struts.TextProvider;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import io.atlassian.util.concurrent.Lazy;
import io.atlassian.util.concurrent.LazyReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewAgentPlanMatrix
extends GlobalAdminAction {
    private static final Logger log = Logger.getLogger(ViewAgentPlanMatrix.class);
    private List<ElasticImageConfiguration> images;
    private Boolean isElasticEnabled;
    private boolean showDisabled;
    private AgentManager agentManager;
    private CapabilityRequirementsMatcher capabilityRequirementsMatcher;
    private CapabilitySetManager capabilitySetManagerNoTx;
    private ElasticImageConfigurationAccessor elasticImageConfigurationAccessor;
    private AgentAssignmentService agentAssignmentService;
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    private List<ImmutablePlan> selectedPlans;
    private String[] selectedBuilds;
    private final CallableResultCache<CapabilitySet> sharedCapabilitiesCache = CallableResultCache.build((CacheBuilder)CacheBuilder.newBuilder());
    private final Supplier<List<BuildAgent>> agents = Lazy.supplier((Supplier)new Supplier<List<BuildAgent>>(){

        @Override
        public List<BuildAgent> get() {
            return Ordering.natural().sortedCopy(Iterables.filter((Iterable)ViewAgentPlanMatrix.this.agentManager.getAllNonElasticAgents(), BuildAgentPredicates::isActiveAndEnabled));
        }
    });
    private final LazyReference<CapabilityHelper> cachingCapabilityHelper = new LazyReference<CapabilityHelper>(){

        protected CapabilityHelper create() throws Exception {
            return new CachingCapabitilityHelper(ViewAgentPlanMatrix.this.getPluginAccessor());
        }
    };

    public Map<Long, CapabilityMatchResult> getAgentPlanMatrixRow(ImmutableBuildable buildable) {
        HashMap<Long, CapabilityMatchResult> planMatches = new HashMap<Long, CapabilityMatchResult>();
        Iterable agentAssignmentExecutables = AgentAssignmentServiceHelper.asExecutables((ImmutableBuildable)buildable);
        for (BuildAgent agent : this.agents.get()) {
            planMatches.put(agent.getId(), this.getMatchResult(agent, buildable.getEffectiveRequirementSet(), agentAssignmentExecutables));
        }
        return planMatches;
    }

    public Map<Long, CapabilityMatchResult> getImagePlanMatrixRow(ImmutableBuildable buildable) {
        HashMap<Long, CapabilityMatchResult> imageMatches = new HashMap<Long, CapabilityMatchResult>();
        if (this.elasticFunctionalityFacade.isElasticSupportEnabled()) {
            List<ElasticImageConfiguration> elasticImageConfigurations = this.getImages();
            for (ElasticImageConfiguration elasticImageConfiguration : elasticImageConfigurations) {
                CapabilityMatchResult capabilityMatchResult = this.capabilityRequirementsMatcher.matchesWithResult((ReadOnlyCapabilitySet)elasticImageConfiguration.getCapabilitySet(), (MinimalRequirementSet)buildable.getEffectiveRequirementSet());
                CapabilityMatchResult capabilityMatchResultWithAssignments = this.addAssignmentCheckResultIfNeeded(capabilityMatchResult, AgentAssignmentServiceHelper.asExecutables((ImmutableBuildable)buildable), AgentAssignmentServiceHelper.asExecutors((ElasticImageConfiguration)elasticImageConfiguration));
                imageMatches.put(elasticImageConfiguration.getId(), capabilityMatchResultWithAssignments);
            }
        }
        return imageMatches;
    }

    public boolean isElasticEnabled() {
        if (this.isElasticEnabled == null) {
            this.isElasticEnabled = this.elasticFunctionalityFacade.isElasticSupportEnabled() && !this.elasticImageConfigurationAccessor.getAllElasticImageConfigurationsForCurrentRegion().isEmpty();
        }
        return this.isElasticEnabled;
    }

    public List<BuildAgent> getAgents() {
        return this.agents.get();
    }

    public List<ElasticImageConfiguration> getImages() {
        if (this.images == null) {
            this.images = this.elasticImageConfigurationAccessor.getAllElasticImageConfigurationsForCurrentRegion();
        }
        return this.images;
    }

    @Nullable
    public Collection<? extends ImmutableJob> getBuildablesForPlan(ImmutablePlan plan) {
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(plan.getPlanKey(), ImmutableChain.class);
        if (chain == null) {
            return null;
        }
        return chain.getAllJobs().stream().filter(job -> !job.isSuspendedFromBuilding()).collect(Collectors.toCollection(ArrayList::new));
    }

    public CapabilityRequirementSetDecorator getDecoratedSet(Collection<ImmutableRequirement> requirements) {
        return new CapabilityRequirementSetDecorator(requirements, (TextProvider)this, (CapabilityHelper)this.cachingCapabilityHelper.get());
    }

    public boolean isShowDisabled() {
        return this.showDisabled;
    }

    public void setShowDisabled(boolean showDisabled) {
        this.showDisabled = showDisabled;
    }

    private CapabilityMatchResult getMatchResult(BuildAgent agent, RequirementSet buildRequirementSet, Iterable<AgentAssignmentService.AgentAssignmentExecutable> executables) {
        PipelineDefinition definition = agent.getDefinition();
        CapabilitySet capabilitySet = CapabilitySetProvider.getAgentCapabilitySet((PipelineDefinition)definition);
        Callable<CapabilitySet> callable = () -> CapabilitySetManagerUtils.getSharedCapabilitySet((CapabilitySetManager)this.capabilitySetManagerNoTx, capabilitySet.getClass());
        CapabilitySet sharedCapabilitySet = (CapabilitySet)this.sharedCapabilitiesCache.call(callable, new Object[]{capabilitySet.getClass()});
        CapabilityMatchResult capabilityMatchResult = this.capabilityRequirementsMatcher.matchesWithResult(this.capabilitySetManagerNoTx.getCombinedCapabilitySet(capabilitySet, sharedCapabilitySet), (MinimalRequirementSet)buildRequirementSet);
        Iterable executors = AgentAssignmentServiceHelper.asExecutors((BuildAgent)agent);
        return this.addAssignmentCheckResultIfNeeded(capabilityMatchResult, executables, executors);
    }

    private CapabilityMatchResult addAssignmentCheckResultIfNeeded(CapabilityMatchResult capabilityMatchResult, Iterable<AgentAssignmentService.AgentAssignmentExecutable> executable, Iterable<AgentAssignmentService.AgentAssignmentExecutor> executors) {
        AgentAssignmentMap.AgentAssignmentCheckResult agentAssignmentCheckResult = this.agentAssignmentService.getAgentAssignments().checkAssignmentRequirements(executable, executors);
        if (AgentAssignmentHelper.isAssignmentCheckPassed((AgentAssignmentMap.AgentAssignmentCheckResult)agentAssignmentCheckResult)) {
            return capabilityMatchResult;
        }
        CapabilityMatchResult capabilityMatchResultWithAssignments = new CapabilityMatchResult(capabilityMatchResult);
        capabilityMatchResultWithAssignments.setMatches(false);
        switch (agentAssignmentCheckResult) {
            case AGENT_EXCLUSIVELY_ASSIGNED_ELSEWHERE: 
            case AGENT_DOES_NOT_MEET_ASSIGNMENT_REQUIREMENTS: {
                capabilityMatchResultWithAssignments.getOtherRejectionReasons().add(this.getText("agents.assignment.agent." + agentAssignmentCheckResult.toString().toLowerCase()));
                break;
            }
            default: {
                capabilityMatchResultWithAssignments.getOtherRejectionReasons().add("Unknown rejection reason");
            }
        }
        return capabilityMatchResultWithAssignments;
    }

    @Nullable
    public List<ImmutablePlan> getSelectedPlans() {
        if (this.selectedPlans == null) {
            this.selectedPlans = ArrayUtils.isNotEmpty((Object[])this.selectedBuilds) ? (List<Object>)Arrays.stream(this.selectedBuilds).map(PlanKeys::getPlanKey).map(arg_0 -> ((CachedPlanManager)this.cachedPlanManager).getPlanByKey(arg_0)).sorted((Comparator<ImmutablePlan>)Comparators.getPlanNameProviderCaseInsensitiveOrdering()).collect(Collectors.toCollection(ArrayList::new)) : new ArrayList<ImmutablePlan>();
        }
        return this.selectedPlans;
    }

    public void setSelectedBuilds(String[] selectedBuilds) {
        this.selectedBuilds = selectedBuilds;
    }

    public String[] getSelectedBuilds() {
        return this.selectedBuilds;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setCapabilityRequirementsMatcher(CapabilityRequirementsMatcher capabilityRequirementsMatcher) {
        this.capabilityRequirementsMatcher = capabilityRequirementsMatcher;
    }

    public void setCapabilitySetManagerNoTx(CapabilitySetManager capabilitySetManagerNoTx) {
        this.capabilitySetManagerNoTx = capabilitySetManagerNoTx;
    }

    public void setElasticImageConfigurationAccessor(ElasticImageConfigurationAccessor elasticImageConfigurationAccessor) {
        this.elasticImageConfigurationAccessor = elasticImageConfigurationAccessor;
    }

    public void setElasticFunctionalityFacade(ElasticFunctionalityFacade elasticFunctionalityFacade) {
        this.elasticFunctionalityFacade = elasticFunctionalityFacade;
    }

    public void setAgentAssignmentService(@NotNull AgentAssignmentService agentAssignmentService) {
        this.agentAssignmentService = agentAssignmentService;
    }

    private static class CachingCapabitilityHelper
    extends CapabilityHelperImpl {
        private final LoadingCache<String, CapabilityType> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, CapabilityType>(){

            public CapabilityType load(String key) throws Exception {
                return CachingCapabitilityHelper.super.getCapabilityTypeFromKey(key);
            }
        });

        public CachingCapabitilityHelper(PluginAccessor pluginAccessor) {
            super(pluginAccessor);
        }

        @Override
        @NotNull
        public CapabilityType getCapabilityTypeFromKey(String key) {
            return (CapabilityType)this.cache.getUnchecked((Object)key);
        }
    }
}

