/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.configuration.GlobalAdminAction;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.LocalAgentDefinitionImpl;
import com.atlassian.xwork.ParameterSafe;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewAgentDetails
extends GlobalAdminAction
implements Preparable {
    protected PipelineDefinition agent;
    protected BuildAgent buildAgent;
    protected long agentId = -1L;
    protected String agentName;
    @Nullable
    protected String agentDescription;
    @Autowired
    protected AgentManager agentManager;

    public void prepare() throws Exception {
        this.buildAgent = this.agentManager.getAgent(this.agentId);
        if (this.buildAgent != null) {
            this.agent = this.buildAgent.getDefinition();
        } else {
            Preconditions.checkArgument((boolean)((FeatureManager)ComponentAccessor.FEATURE_MANAGER.get()).isLocalAgentsSupported(), (Object)"Support for local agents is disabled");
            this.agent = new LocalAgentDefinitionImpl();
        }
        this.agentName = this.agent.getName();
        this.agentDescription = this.agent.getDescription();
    }

    @ParameterSafe
    public PipelineDefinition getAgent() throws Exception {
        if (this.agent == null) {
            this.prepare();
        }
        return this.agent;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public void setAgent(PipelineDefinition agent) {
        this.agent = agent;
    }

    public long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return this.agentName;
    }

    @Nullable
    public String getAgentDescription() {
        return this.agentDescription;
    }
}

