/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.agent.AgentExecutableService;
import com.atlassian.bamboo.build.FilterController;
import com.atlassian.bamboo.build.statistics.SuccessPercentageStatisticsBean;
import com.atlassian.bamboo.build.statistics.SuccessPercentageStatisticsBeanImpl;
import com.atlassian.bamboo.builder.resultsfilter.BuildResultsFilterFactory;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.LocalAgentDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.buildqueue.PipelineDefinitionVisitor;
import com.atlassian.bamboo.buildqueue.RemoteAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.capability.CapabilitySetProvider;
import com.atlassian.bamboo.configuration.SystemInfo;
import com.atlassian.bamboo.deployments.environments.DecoratedEnvironment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentService;
import com.atlassian.bamboo.plan.ExecutableAgentsHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.resultsummary.AgentResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.security.BambooCachingPermissionManagerFacade;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.agent.BuildAgentImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityHelper;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityRequirementSetDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySetManager;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.ww2.BambooActionSupport;
import com.atlassian.bamboo.ww2.aware.permissions.AuthenticatedUserSecurityAware;
import com.atlassian.struts.TextProvider;
import com.atlassian.xwork.ParameterSafe;
import io.atlassian.fugue.Suppliers;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class ViewAgent
extends BambooActionSupport
implements AuthenticatedUserSecurityAware {
    private static final Logger log = Logger.getLogger(ViewAgent.class);
    private CapabilitySet sharedCapabilitySet;
    private Supplier<List<ImmutableBuildable>> executableBuildables = Suppliers.memoize(this::fetchExecutableBuildables);
    private Supplier<List<DecoratedEnvironment>> executableEnvironments = Suppliers.memoize(this::fetchExecutableEnvironments);
    protected long agentId;
    private PipelineDefinition agent;
    private BuildAgent buildAgent;
    protected CapabilitySet capabilitySet;
    private SuccessPercentageStatisticsBean statistics;
    @Autowired
    protected AgentResultsSummaryManager agentResultsSummaryManager;
    @Autowired
    private CapabilitySetManager capabilitySetManager;
    @Autowired
    protected AgentManager agentManager;
    @Autowired
    private BuildResultsFilterFactory buildResultsFilterFactory;
    @Autowired
    private BambooCachingPermissionManagerFacade cachingPermissionManagerFacade;
    @Autowired
    protected CapabilityHelper capabilityHelper;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ExecutableAgentsHelper executableAgentsHelper;
    @Autowired
    private FilterController filterController;
    @Autowired
    protected ResultsSummaryManager resultsSummaryManager;
    @Autowired
    private SystemInfo systemInfo;
    @Autowired
    private AgentExecutableService agentExecutableService;

    @Override
    public boolean hasPlanPermission(String permission, PlanIdentifier plan) {
        return this.cachingPermissionManagerFacade.hasPermission(BambooPermission.buildFromName((String)permission), (Object)plan);
    }

    @Override
    public String doDefault() throws Exception {
        this.initializeAllFields();
        if (this.buildAgent == null) {
            this.addActionError(this.getText("agent.error.notFound", Collections.singletonList(String.valueOf(this.agentId))));
            return "error";
        }
        final String[] result = new String[]{"input"};
        PipelineDefinition agent = this.getAgent();
        agent.accept(new PipelineDefinitionVisitor(){

            public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                if (!ViewAgent.this.featureManager.isElasticAgentsSupported()) {
                    ViewAgent.this.addActionError(ViewAgent.this.getText("agent.error.notFound", Collections.singletonList(String.valueOf(ViewAgent.this.agentId))));
                }
            }

            public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                if (!ViewAgent.this.featureManager.isLocalAgentsSupported()) {
                    ViewAgent.this.addActionError(ViewAgent.this.getText("agent.error.notFound", Collections.singletonList(String.valueOf(ViewAgent.this.agentId))));
                }
            }

            public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                if (!ViewAgent.this.featureManager.isRemoteAgentsSupported()) {
                    ViewAgent.this.addActionError(ViewAgent.this.getText("agent.error.notFound", Collections.singletonList(String.valueOf(ViewAgent.this.agentId))));
                }
            }
        });
        if (this.hasAnyErrors()) {
            return "error";
        }
        final BuildAgent buildAgent = this.getBuildAgent();
        if (agent != null && buildAgent != null) {
            agent.accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                    if (!buildAgent.isActive()) {
                        result[0] = ViewAgent.this.bambooPermissionManager.canManageElasticBamboo() ? "redirectAdminToDeadElasticAgentPage" : "redirectToDeadElasticAgentPage";
                    }
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                }
            });
        }
        return result[0];
    }

    protected void initializeAllFields() {
        this.buildAgent = this.agentManager.getAgent(this.agentId);
        if (this.buildAgent != null) {
            this.agent = this.buildAgent.getDefinition();
        }
        if (this.agent != null) {
            this.capabilitySet = CapabilitySetProvider.getAgentCapabilitySet((PipelineDefinition)this.agent);
            this.agent.accept(new PipelineDefinitionVisitor(){

                public void visitElastic(ElasticAgentDefinition pipelineDefinition) {
                }

                public void visitLocal(LocalAgentDefinition pipelineDefinition) {
                    ViewAgent.this.sharedCapabilitySet = ViewAgent.this.capabilitySetManager.getSharedLocalCapabilitySet();
                }

                public void visitRemote(RemoteAgentDefinition pipelineDefinition) {
                    ViewAgent.this.sharedCapabilitySet = ViewAgent.this.capabilitySetManager.getSharedRemoteCapabilitySet();
                }
            });
            if (this.getBuildAgent() instanceof BuildAgentImpl) {
                this.systemInfo = ((BuildAgentImpl)this.getBuildAgent()).getSystemInfo();
            }
        }
    }

    public SuccessPercentageStatisticsBean getStatistics() {
        if (this.statistics == null) {
            this.statistics = new SuccessPercentageStatisticsBeanImpl(this.agentResultsSummaryManager.countBuildResultsSummariesForAgent(this.buildAgent), this.agentResultsSummaryManager.countFailedBuildResultsSummariesForAgent(this.buildAgent));
        }
        return this.statistics;
    }

    public List<ImmutableBuildable> getExecutableBuildables() {
        return this.executableBuildables.get();
    }

    @NotNull
    private List<ImmutableBuildable> fetchExecutableBuildables() {
        return this.agentExecutableService.fetchExecutableBuildables(this.agent);
    }

    public List<DecoratedEnvironment> getExecutableEnvironments() {
        return this.executableEnvironments.get();
    }

    private List<DecoratedEnvironment> fetchExecutableEnvironments() {
        return this.agentExecutableService.fetchExecutableEnvironments(this.agent);
    }

    @Nullable
    public BuildResultsSummary findLastSuccessfulBuild(ImmutableBuildable plan) {
        return this.agentResultsSummaryManager.getLastSuccessfulBuildForAgent(plan.getKey(), Long.valueOf(this.getAgentId()));
    }

    @Nullable
    public BuildResultsSummary findLastBuild(ImmutableBuildable plan) {
        return this.agentResultsSummaryManager.getLastBuildForAgent(plan.getKey(), Long.valueOf(this.getAgentId()));
    }

    public CapabilityRequirementSetDecorator getSharedCapabilitySetDecorator() {
        return new CapabilityRequirementSetDecorator((ReadOnlyCapabilitySet)this.getSharedCapabilitySet(), null, (TextProvider)this, this.capabilityHelper);
    }

    public CapabilityRequirementSetDecorator getCapabilitySetDecorator() {
        return new CapabilityRequirementSetDecorator((ReadOnlyCapabilitySet)this.getCapabilitySet(), (ReadOnlyCapabilitySet)this.getSharedCapabilitySet(), (TextProvider)this, this.capabilityHelper);
    }

    public CapabilityRequirementSetDecorator getCombinedCapabilitySetDecorator() {
        return new CapabilityRequirementSetDecorator(this.capabilitySetManager.getCombinedCapabilitySet(this.agentId), null, (TextProvider)this, this.capabilityHelper);
    }

    public CapabilitySet getCapabilitySet() {
        return this.capabilitySet;
    }

    public CapabilitySet getSharedCapabilitySet() {
        return this.sharedCapabilitySet;
    }

    public void setSharedCapabilitySet(CapabilitySet sharedCapabilitySet) {
        this.sharedCapabilitySet = sharedCapabilitySet;
    }

    public long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(long agentId) {
        this.agentId = agentId;
    }

    public PipelineDefinition getAgent() {
        return this.agent;
    }

    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public void setAgent(PipelineDefinition agent) {
        this.agent = agent;
    }

    public BuildAgent getBuildAgent() {
        return this.buildAgent;
    }

    public void setSystemInfo(SystemInfo systemInfo) {
        this.systemInfo = systemInfo;
    }

    @ParameterSafe
    public FilterController getFilterController() {
        return this.filterController;
    }

    public BuildResultsFilterFactory getBuildResultsFilterFactory() {
        return this.buildResultsFilterFactory;
    }
}

