/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.buildqueue.PipelineDefinition;
import com.atlassian.bamboo.configuration.agent.AgentCapabilityDelta;
import com.atlassian.bamboo.configuration.agent.ConfigureCapabilityKey;
import com.atlassian.bamboo.configuration.agent.EditAgentCapability;
import com.atlassian.bamboo.configuration.agent.RequirementDelta;
import com.atlassian.bamboo.deployments.environments.DecoratedEnvironment;
import com.atlassian.bamboo.deployments.projects.persistence.RequirementDeploymentMapping;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.v2.build.agent.LocalAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.RemoteAgentDefinitionImpl;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityAgentMapping;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityGroup;
import com.atlassian.bamboo.v2.build.agent.capability.LocalCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.RemoteCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementAware;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImmutablePlanMapping;
import com.atlassian.bamboo.v2.build.requirement.ImmutableRequirement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class RenameAgentCapability
extends ConfigureCapabilityKey {
    private static final Logger log = Logger.getLogger(EditAgentCapability.class);
    static final PipelineDefinition SHARED_LOCAL_CAPABILITIES = new LocalAgentDefinitionImpl(-1000L, "Local");
    static final PipelineDefinition SHARED_REMOTE_CAPABILITIES = new RemoteAgentDefinitionImpl(-100L, "Remote");
    private String newCapabilityLabel;
    protected String newCapabilityKey;
    private String overrideValue = Boolean.FALSE.toString();
    private Map<ImmutableJob, RequirementDelta> requirementPlanDeltaMap;
    private Map<DecoratedEnvironment, RequirementDelta> requirementEnvironmentDeltaMap;
    private Map<PipelineDefinition, AgentCapabilityDelta> capabilityDeltaMap;

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.newCapabilityLabel)) {
            this.addFieldError("newCapabilityLabel", "Please enter a new label");
        } else {
            this.newCapabilityLabel = this.newCapabilityLabel.trim();
            if (this.newCapabilityLabel.equalsIgnoreCase(this.getCapability().getLabel())) {
                this.addFieldError("newCapabilityLabel", "New label cannot be same as the previous label");
            }
        }
    }

    @Override
    public String doDefault() throws Exception {
        return this.capabilityType.isAllowRename() ? "input" : "renameNotAllowed";
    }

    public String confirmRename() throws Exception {
        this.newCapabilityKey = this.capabilityType.getNewKeyFromLabel(this.getCapabilityKey(), this.getNewCapabilityLabel());
        List targetCapabilityAgentMappings = this.capabilityDao.getCapabilitiesFromKey(this.newCapabilityKey);
        this.capabilityDeltaMap = this.findAgentCapabilityDelta(this.capabilityAgentMappings, targetCapabilityAgentMappings);
        List<RequirementImmutablePlanMapping> targetRequirementPlanMappings = this.getRequirementsFromKey(this.newCapabilityKey);
        this.requirementPlanDeltaMap = this.findRequirementPlanDelta(this.requirementPlanMappings, targetRequirementPlanMappings);
        Set targetRequirementDeploymentMappings = this.environmentService.findEnvironmentsByRequirementKey(this.newCapabilityKey);
        this.requirementEnvironmentDeltaMap = this.findRequirementDeploymentDelta(this.requirementDeploymentEnvironmentMappings, targetRequirementDeploymentMappings);
        if (!(this.requirementPlanDeltaMap.isEmpty() && this.capabilityDeltaMap.isEmpty() && this.requirementEnvironmentDeltaMap.isEmpty())) {
            return "needConfirm";
        }
        return "success";
    }

    public List<NameValuePair> getOverrideOptions() {
        String oldLabel = this.getText("agent.capability.type." + this.getCapabilityType().toString() + ".value.old", new String[]{this.getCapability().getLabel()});
        String newLabel = this.getText("agent.capability.type." + this.getCapabilityType().toString() + ".value.new", new String[]{this.getNewCapabilityLabel()});
        return Lists.newArrayList((Object[])new NameValuePair[]{new NameValuePair(Boolean.TRUE.toString(), this.getText("agent.capability.rename.use", new String[]{oldLabel})), new NameValuePair(Boolean.FALSE.toString(), this.getText("agent.capability.rename.use", new String[]{newLabel}))});
    }

    @NotNull
    @VisibleForTesting
    Map<PipelineDefinition, AgentCapabilityDelta> findAgentCapabilityDelta(List<CapabilityAgentMapping> capabilityAgentMappings, List<CapabilityAgentMapping> targetCapabilityAgentMappings) {
        TreeMap<PipelineDefinition, Capability> newMappings = new TreeMap<PipelineDefinition, Capability>();
        for (CapabilityAgentMapping capabilityAgentMapping : targetCapabilityAgentMappings) {
            PipelineDefinition mappingKey = this.getAgentFromMapping(capabilityAgentMapping);
            newMappings.put(mappingKey, capabilityAgentMapping.getCapability());
        }
        HashMap<PipelineDefinition, AgentCapabilityDelta> deltaMap = new HashMap<PipelineDefinition, AgentCapabilityDelta>();
        for (CapabilityAgentMapping capabilityAgentMapping : capabilityAgentMappings) {
            PipelineDefinition pipelineDefinition = this.getAgentFromMapping(capabilityAgentMapping);
            Capability targetMapping = (Capability)newMappings.get(pipelineDefinition);
            if (targetMapping == null) continue;
            deltaMap.put(pipelineDefinition, new AgentCapabilityDelta(capabilityAgentMapping.getCapability(), targetMapping));
        }
        return deltaMap;
    }

    @NotNull
    private PipelineDefinition getAgentFromMapping(@NotNull CapabilityAgentMapping capabilityAgentMapping) {
        PipelineDefinition pipelineDefinition;
        Long agentId = capabilityAgentMapping.getAgentId();
        Capability value = capabilityAgentMapping.getCapability();
        if (agentId != null && (pipelineDefinition = this.agentManager.getAgentDefinition(agentId)) != null) {
            return pipelineDefinition;
        }
        if (value.getCapabilitySet() instanceof LocalCapabilitySet) {
            return SHARED_LOCAL_CAPABILITIES;
        }
        if (value.getCapabilitySet() instanceof RemoteCapabilitySet) {
            return SHARED_REMOTE_CAPABILITIES;
        }
        throw new IllegalArgumentException("Invalid Capability Agent Mapping. Could not retrieve Agent.");
    }

    @NotNull
    private Map<ImmutableJob, RequirementDelta> findRequirementPlanDelta(List<RequirementImmutablePlanMapping> requirementPlanMappings, List<RequirementImmutablePlanMapping> targetRequirementPlanMappings) {
        TreeMap<ImmutableJob, RequirementImmutablePlanMapping> newMappings = new TreeMap<ImmutableJob, RequirementImmutablePlanMapping>();
        for (RequirementImmutablePlanMapping requirementPlanMapping : targetRequirementPlanMappings) {
            newMappings.put((ImmutableJob)requirementPlanMapping.getRequirementAware().getWrappedObject(), requirementPlanMapping);
        }
        HashMap<ImmutableJob, RequirementDelta> deltaMap = new HashMap<ImmutableJob, RequirementDelta>();
        for (RequirementImmutablePlanMapping requirementPlanMapping : requirementPlanMappings) {
            ImmutableJob build = (ImmutableJob)requirementPlanMapping.getRequirementAware().getWrappedObject();
            RequirementImmutablePlanMapping targetMapping = (RequirementImmutablePlanMapping)newMappings.get(build);
            if (targetMapping == null) continue;
            this.processConflict(build.getName(), build, requirementPlanMapping.getRequirement(), targetMapping.getRequirement(), deltaMap);
        }
        return deltaMap;
    }

    @NotNull
    private Map<DecoratedEnvironment, RequirementDelta> findRequirementDeploymentDelta(List<RequirementDeploymentMapping> requirementDeploymentMappings, Collection<RequirementDeploymentMapping> targetRequirementDeploymentMappings) {
        TreeMap<DecoratedEnvironment, RequirementDeploymentMapping> newMappings = new TreeMap<DecoratedEnvironment, RequirementDeploymentMapping>();
        for (RequirementDeploymentMapping requirementDeploymentMapping : targetRequirementDeploymentMappings) {
            newMappings.put((DecoratedEnvironment)requirementDeploymentMapping.getRequirementAware().getWrappedObject(), requirementDeploymentMapping);
        }
        HashMap<DecoratedEnvironment, RequirementDelta> deltaMap = new HashMap<DecoratedEnvironment, RequirementDelta>();
        for (RequirementDeploymentMapping requirementDeploymentMapping : requirementDeploymentMappings) {
            DecoratedEnvironment env = (DecoratedEnvironment)requirementDeploymentMapping.getRequirementAware().getWrappedObject();
            RequirementDeploymentMapping targetMapping = (RequirementDeploymentMapping)newMappings.get(env);
            if (targetMapping == null) continue;
            this.processConflict(env.getName(), env, requirementDeploymentMapping.getRequirement(), targetMapping.getRequirement(), deltaMap);
        }
        return deltaMap;
    }

    private <T> void processConflict(String conflictEntityName, T conflictEntity, Requirement sourceRequirement, Requirement targetRequirement, Map<T, RequirementDelta> deltaMap) {
        RequirementAware requirementAware = new RequirementAware(conflictEntityName, conflictEntity);
        CapabilityGroup capabilityGroup = new CapabilityGroup(this.capabilityType, (TextProvider)this);
        RequirementDecorator oldRequirement = new RequirementDecorator((ImmutableRequirement)sourceRequirement, this.capabilityType, (TextProvider)this, capabilityGroup, requirementAware);
        RequirementDecorator newRequirement = new RequirementDecorator((ImmutableRequirement)targetRequirement, this.capabilityType, (TextProvider)this, capabilityGroup, requirementAware);
        deltaMap.put(conflictEntity, new RequirementDelta(oldRequirement, newRequirement));
    }

    public String getNewCapabilityKey() {
        return this.newCapabilityKey;
    }

    public String getNewCapabilityLabel() {
        return this.newCapabilityLabel;
    }

    public void setNewCapabilityLabel(String newCapabilityLabel) {
        this.newCapabilityLabel = newCapabilityLabel;
    }

    public boolean isOverride() {
        return Boolean.TRUE.toString().equals(this.getOverrideValue());
    }

    public Map<PipelineDefinition, AgentCapabilityDelta> getCapabilityDeltaMap() {
        return this.capabilityDeltaMap;
    }

    public Map<ImmutableJob, RequirementDelta> getRequirementPlanDeltaMap() {
        return this.requirementPlanDeltaMap;
    }

    public Map<DecoratedEnvironment, RequirementDelta> getRequirementEnvironmentDeltaMap() {
        return this.requirementEnvironmentDeltaMap;
    }

    public String getOverrideValue() {
        return this.overrideValue;
    }

    public void setOverrideValue(String overrideValue) {
        this.overrideValue = overrideValue;
    }
}

