/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.buildqueue.RemoteAgentAuthentication;
import com.atlassian.bamboo.configuration.agent.AbstractRemoteAgentAuthenticationAction;
import com.atlassian.ip.Subnet;
import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class EditRemoteAgentAuthenticationIp
extends AbstractRemoteAgentAuthenticationAction {
    private static final Logger log = Logger.getLogger(EditRemoteAgentAuthenticationIp.class);
    private String authenticationUuid;
    private String ipAddress;
    private boolean initError = false;
    private RemoteAgentAuthentication authentication;

    public String input() throws Exception {
        this.initAuthentication();
        if (!this.hasActionErrors()) {
            this.ipAddress = this.authentication.getIp();
        } else {
            this.initError = true;
        }
        return "input";
    }

    public String editIp() {
        this.initAuthentication();
        this.validateIp();
        if (!this.hasErrors()) {
            this.remoteAgentAuthenticationManager.updateIp(this.authentication.getUuid(), this.ipAddress);
        }
        return this.hasErrors() ? "error" : "success";
    }

    private void initAuthentication() {
        if (StringUtils.isEmpty((CharSequence)this.authenticationUuid)) {
            this.addActionError(this.getText("agent.remote.authentication.action.uuidMissing"));
            return;
        }
        this.authentication = this.findByUuid(this.authenticationUuid);
        if (this.authentication != null && !this.authentication.isApproved()) {
            this.addActionError(this.getText("agent.remote.authentication.action.authenticationNotApproved", new String[]{this.authenticationUuid}));
        }
    }

    @VisibleForTesting
    void validateIp() {
        if (StringUtils.isBlank((CharSequence)this.ipAddress)) {
            this.addFieldError("ipAddress", this.getText("agent.remote.authentication.action.ipMissing"));
        }
        try {
            String[] addresses;
            for (String address : addresses = this.ipAddress.split(",")) {
                Subnet.forPattern((String)address);
            }
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            this.addFieldError("ipAddress", this.getText("agent.remote.authentication.action.ipInvalid"));
        }
    }

    @Override
    protected void onAuthenticationNotFound(String uuid, UUID parsedUuid) {
        this.addActionError(this.getText("agent.remote.authentication.action.authenticationNotFound", new String[]{uuid}));
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getAuthenticationUuid() {
        return this.authenticationUuid;
    }

    public void setAuthenticationUuid(String authenticationUuid) {
        this.authenticationUuid = authenticationUuid;
    }

    public boolean isInitError() {
        return this.initError;
    }
}

