/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration.agent;

import com.atlassian.bamboo.configuration.agent.ConfigureAgentCapability;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityDecorator;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityGroup;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySource;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityType;
import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.TextProvider;
import org.apache.commons.lang3.StringUtils;

public class EditAgentCapability
extends ConfigureAgentCapability {
    private String capabilityValue;
    private CapabilityDecorator capability;

    @Override
    public void prepare() throws Exception {
        super.prepare();
        Preconditions.checkNotNull((Object)this.getCurrentlyEditedCapabilitySet(), (Object)"there is no capability set to edit");
        Capability capability = this.getCurrentlyEditedCapabilitySet().getCapability(this.capabilityKey);
        if (capability != null) {
            this.capabilityValue = capability.getValueWithDefault();
        }
        this.capabilityType = this.capabilityHelper.getCapabilityType(this.capabilityKey);
        CapabilityType capabilityType = this.capabilityHelper.getCapabilityTypeFromKey(this.capabilityKey);
        this.capability = new CapabilityDecorator(this.capabilityKey, null, null, -1L, capabilityType, null, (TextProvider)this, new CapabilityGroup(capabilityType, (TextProvider)this), null);
    }

    protected CapabilitySet getCurrentlyEditedCapabilitySet() {
        return this.capabilitySet;
    }

    protected CapabilitySource getCapabilitySource() {
        return CapabilitySource.UI;
    }

    public void validate() {
        if (StringUtils.isBlank((CharSequence)this.capabilityKey)) {
            this.addActionError("capabilityKey must be supplied");
        } else {
            Capability capability = this.getCurrentlyEditedCapabilitySet().getCapability(this.capabilityKey);
            if (capability == null) {
                this.addActionError("Cannot find capabilityKey " + this.capabilityKey + " in " + this.agent.getName());
                return;
            }
            if (StringUtils.isBlank((CharSequence)this.capabilityValue)) {
                this.addFieldError("capabilityValue", "Need to add a value for the value field");
            } else {
                this.capabilityValue = this.capabilityValue.trim();
            }
        }
    }

    @Override
    public String doDefault() throws Exception {
        Capability capability = this.getCurrentlyEditedCapabilitySet().getCapability(this.capabilityKey);
        this.capabilityValue = capability.getValueWithDefault();
        return "input";
    }

    public String editCapability() {
        if (this.agent != null) {
            this.addErrorCollection(this.agentCapabilityService.updateCapability(this.agent, this.capabilityKey, this.capabilityValue, this.getCapabilitySource()));
        } else {
            Capability capability = this.getCurrentlyEditedCapabilitySet().getCapability(this.capabilityKey);
            capability.setValue(this.capabilityValue);
            capability.setCapabilitySource(this.getCapabilitySource());
            this.capabilitySetManager.saveCapabilitySet(this.getCurrentlyEditedCapabilitySet());
        }
        return "success";
    }

    public CapabilityDecorator getCapability() {
        return this.capability;
    }

    public String getCapabilityValue() {
        return this.capabilityValue;
    }

    public void setCapabilityValue(String capabilityValue) {
        this.capabilityValue = capabilityValue;
    }
}

